<?php
/**
 * @license proprietary
 *
 * Modified by Beau Fiechter on 14-June-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */

namespace WRCE\Dependencies\WordpressModels\DependencyInjection\Metabox\Attributes;

use Attribute;

/**
 * Attribute to register a metabox.
 */
#[Attribute(Attribute::TARGET_CLASS | Attribute::IS_REPEATABLE)]
class AsMetabox
{

    /**
     * @param string $id
     * @param string $title
     * @param 'normal'|'side'|'advanced' $context
     * @psalm-param 'normal'|'side'|'advanced' $context
     * @param 'default'|'high'|'low' $priority
     * @psalm-param 'default'|'high'|'low' $priority
     * @param string|null $postType
     */
    public function __construct(
        public string $id,
        public string $title,
        public string $context = 'normal',
        public string $priority = 'default',
        public string|null $postType = null,
    ) {
    }

}