<?php
/**
 * @license MIT
 *
 * Modified by Beau Fiechter on 14-June-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */

declare(strict_types=1);

namespace WRCE\Dependencies\Doctrine\ORM\Mapping;

/**
 * Is used to specify an array of mappings.
 * The SqlResultSetMappings annotation can be applied to an entity or mapped superclass.
 *
 * @Annotation
 * @Target("CLASS")
 */
final class SqlResultSetMappings implements MappingAttribute
{
    /**
     * One or more SqlResultSetMapping annotations.
     *
     * @var array<\Doctrine\ORM\Mapping\SqlResultSetMapping>
     */
    public $value = [];
}
