<?php
/**
 * @license MIT
 *
 * Modified by Beau Fiechter on 14-June-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */

namespace WRCE\Dependencies\Doctrine\Bundle\DoctrineBundle\Command\Proxy;

use WRCE\Dependencies\Doctrine\ORM\Tools\Console\Command\ClearCache\CollectionRegionCommand;
use WRCE\Dependencies\Symfony\Component\Console\Input\InputOption;

/**
 * Command to clear a collection cache region.
 *
 * @deprecated use WRCE\Dependencies\Doctrine\ORM\Tools\Console\Command\ClearCache\CollectionRegionCommand instead
 */
class CollectionRegionDoctrineCommand extends CollectionRegionCommand
{
    use OrmProxyCommand;

    protected function configure(): void
    {
        parent::configure();

        $this
            ->setName('doctrine:cache:clear-collection-region');

        if ($this->getDefinition()->hasOption('em')) {
            return;
        }

        $this->addOption('em', null, InputOption::VALUE_OPTIONAL, 'The entity manager to use for this command');
    }
}
