<?php

namespace RTMCustomMails;

use RTMMailComposer\Model\EmailDocumentInterface;
use WPO\WC\PDF_Invoices\Documents\Order_Document;

class WCPDFDocument implements EmailDocumentInterface
{

    private Order_Document $document;

    private function __construct(Order_Document $document)
    {
        $this->document = $document;
    }

    public function getSlug(): string
    {
        return $this->document->get_type();
    }

    public function getName(): string
    {
        return $this->document->get_title();
    }

    public function getIcon(): string
    {
        return $this->document->icon;
    }

    public static function createFromDocument(Order_Document $document)
    {
        return new self($document);
    }
}