<?php

namespace RTMCustomMails;

use RTMCustomMails\Email\RTMCustomEmail;
use RTMCustomMails\EmailOptions\TriggerHooksOption;
use WC_Email;
use WRCE\Dependencies\WordpressModels\Traits\SingletonTrait;

class EmailTriggerHooks
{

    use SingletonTrait;

    public function __construct()
    {
        add_filter('wrce_email_trigger_hooks', [$this, 'applyFilterHookOptionValue'], 10, 2);
        add_filter('wrce_register_options', [$this, 'addTriggerHookOption']);
    }

    /**
     * Add 'trigger_hooks' option to all available email types.
     *
     * @param \WC_Email[] $instances
     * @return void
     */
    public function addTriggerHookOption(array $instances): void
    {
        foreach ($instances as $instance) {
            $instance = RTMCustomEmail::asCustomEmail($instance);
            $instance->addOption(TriggerHooksOption::class);
        }
    }

    public function applyFilterHookOptionValue(array $hooks, WC_Email $email): array
    {
        return (array)$email->get_option('trigger_hooks', $hooks);
    }

}