<?php
/**
 * @license proprietary
 *
 * Modified by Beau Fiechter on 14-June-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */

namespace WRCE\Dependencies\WordpressModels\Rest\Permissions;

use WRCE\Dependencies\Symfony\Component\ExpressionLanguage\ExpressionFunction;
use WRCE\Dependencies\Symfony\Component\ExpressionLanguage\ExpressionFunctionProviderInterface;

class CapabilityExpressionFunctionProvider implements ExpressionFunctionProviderInterface
{

    public function __construct(private readonly PermissionFunctionsInterface $permissionFunctions)
    {
    }

    public function compile(string $value): string
    {
        $class = $this->permissionFunctions::class;
        return "$class::userHasCapability('$value')";
    }

    public function evaluate($args, string $capability): bool
    {
        return $this->permissionFunctions::userHasCapability($capability);
    }

    public function getFunctions(): array
    {
        return [
            new ExpressionFunction('capability', $this->compile(...), $this->evaluate(...)),
        ];
    }
}