<?php
/*
 * Copyright (c) 2023. RTM Business
 *
 * @license proprietary
 * Modified by Beau Fiechter on 14-June-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */

namespace WRCE\Dependencies\WordpressModels\ORM\WooCommerceEntity;

use WRCE\Dependencies\Doctrine\DBAL\Types\Types;
use WRCE\Dependencies\Doctrine\ORM\Mapping\Column;
use WRCE\Dependencies\Doctrine\ORM\Mapping\Entity;
use WRCE\Dependencies\Doctrine\ORM\Mapping\GeneratedValue;
use WRCE\Dependencies\Doctrine\ORM\Mapping\Id;
use WRCE\Dependencies\Doctrine\ORM\Mapping\JoinColumn;
use WRCE\Dependencies\Doctrine\ORM\Mapping\ManyToOne;
use WRCE\Dependencies\Doctrine\ORM\Mapping\Table;
use WRCE\Dependencies\WordpressModels\ORM\Entity\User;

/**
 * Doctrine entity matching the `wp_woocommerce_api_keys` table.
 *
 * Columns:
 * key_id
 * user_id
 * description
 * permissions
 * consumer_key
 * consumer_secret
 * nonces
 * truncated_key
 * last_access
 *
 */
#[Entity]
#[Table(name: 'api_keys')]
class ApiKey
{

    #[Id]
    #[GeneratedValue(strategy: 'IDENTITY')]
    #[Column(name: 'key_id', type: Types::BIGINT, options: ['unsigned' => true])]
    private int $id;

    #[ManyToOne(targetEntity: User::class)]
    #[JoinColumn(name: 'user_id', referencedColumnName: 'ID')]
    private User $user;

    #[Column(name: 'description', type: Types::TEXT)]
    private string $description;

    #[Column(name: 'permissions', type: Types::TEXT)]
    private string $permissions;

    #[Column(name: 'consumer_key', type: Types::STRING, length: 64)]
    private string $consumerKey;

    #[Column(name: 'consumer_secret', type: Types::STRING, length: 43)]
    private string $consumerSecret;

    #[Column(name: 'nonces', type: Types::TEXT)]
    private string $nonces;

    #[Column(name: 'truncated_key', type: Types::STRING, length: 7)]
    private string $truncatedKey;

    #[Column(name: 'last_access', type: Types::DATETIME_MUTABLE)]
    private \DateTime $lastAccess;

    /**
     * @return int
     */
    public function getId(): int
    {
        return $this->id;
    }

    /**
     * @param int $id
     * @return ApiKey
     */
    public function setId(int $id): ApiKey
    {
        $this->id = $id;
        return $this;
    }

    /**
     * @return string
     */
    public function getDescription(): string
    {
        return $this->description;
    }

    /**
     * @param string $description
     * @return ApiKey
     */
    public function setDescription(string $description): ApiKey
    {
        $this->description = $description;
        return $this;
    }

    /**
     * @return string
     */
    public function getPermissions(): string
    {
        return $this->permissions;
    }

    /**
     * @param string $permissions
     * @return ApiKey
     */
    public function setPermissions(string $permissions): ApiKey
    {
        $this->permissions = $permissions;
        return $this;
    }

    /**
     * @return string
     */
    public function getConsumerKey(): string
    {
        return $this->consumerKey;
    }

    /**
     * @param string $consumerKey
     * @return ApiKey
     */
    public function setConsumerKey(string $consumerKey): ApiKey
    {
        $this->consumerKey = $consumerKey;
        return $this;
    }

    /**
     * @return string
     */
    public function getConsumerSecret(): string
    {
        return $this->consumerSecret;
    }

    /**
     * @param string $consumerSecret
     * @return ApiKey
     */
    public function setConsumerSecret(string $consumerSecret): ApiKey
    {
        $this->consumerSecret = $consumerSecret;
        return $this;
    }

    /**
     * @return string
     */
    public function getNonces(): string
    {
        return $this->nonces;
    }

    /**
     * @param string $nonces
     * @return ApiKey
     */
    public function setNonces(string $nonces): ApiKey
    {
        $this->nonces = $nonces;
        return $this;
    }

    /**
     * @return string
     */
    public function getTruncatedKey(): string
    {
        return $this->truncatedKey;
    }

    /**
     * @param string $truncatedKey
     * @return ApiKey
     */
    public function setTruncatedKey(string $truncatedKey): ApiKey
    {
        $this->truncatedKey = $truncatedKey;
        return $this;
    }

    /**
     * @return \DateTime
     */
    public function getLastAccess(): \DateTime
    {
        return $this->lastAccess;
    }

    /**
     * @param \DateTime $lastAccess
     * @return ApiKey
     */
    public function setLastAccess(\DateTime $lastAccess): ApiKey
    {
        $this->lastAccess = $lastAccess;
        return $this;
    }

}