<?php
/**
 * @license proprietary
 *
 * Modified by Beau Fiechter on 14-June-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */

namespace WRCE\Dependencies\WordpressModels\DependencyInjection\Initializer;

use WRCE\Dependencies\Symfony\Component\DependencyInjection\Compiler\CompilerPassInterface;
use WRCE\Dependencies\Symfony\Component\DependencyInjection\ContainerBuilder;

class InitializerCompilerPass implements CompilerPassInterface
{


    public function process(ContainerBuilder $container)
    {
        $initializer = $container->getDefinition(ServiceInitializer::class);
        $services = $container->findTaggedServiceIds('force_initialize');

        foreach ($services as $id => $tags) {
            $initializer->addMethodCall('addService', [$id]);
        }
    }
}