<?php
/**
 * @license MIT
 *
 * Modified by Beau Fiechter on 14-June-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */

declare(strict_types=1);

namespace WRCE\Dependencies\Doctrine\ORM\Query\AST;

class GroupByClause extends Node
{
    /** @var mixed[] */
    public $groupByItems = [];

    /** @param mixed[] $groupByItems */
    public function __construct(array $groupByItems)
    {
        $this->groupByItems = $groupByItems;
    }

    /**
     * {@inheritDoc}
     */
    public function dispatch($sqlWalker)
    {
        return $sqlWalker->walkGroupByClause($this);
    }
}
