<?php
/**
 * @license MIT
 *
 * Modified by Beau Fiechter on 14-June-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */

namespace WRCE\Dependencies\Doctrine\Bundle\DoctrineBundle\Command\Proxy;

use WRCE\Dependencies\Doctrine\ORM\Tools\Console\Command\ClearCache\QueryRegionCommand;
use WRCE\Dependencies\Symfony\Component\Console\Input\InputOption;

/**
 * Command to clear a query cache region.
 *
 * @deprecated use WRCE\Dependencies\Doctrine\ORM\Tools\Console\Command\ClearCache\QueryRegionCommand instead
 */
class QueryRegionCacheDoctrineCommand extends QueryRegionCommand
{
    use OrmProxyCommand;

    protected function configure(): void
    {
        parent::configure();

        $this
            ->setName('doctrine:cache:clear-query-region');

        if ($this->getDefinition()->hasOption('em')) {
            return;
        }

        $this->addOption('em', null, InputOption::VALUE_OPTIONAL, 'The entity manager to use for this command');
    }
}
