<?php

namespace RTMCustomMails;

use RTMCustomMails\Email\RTMCustomEmail;
use RTMCustomMails\EmailOptions\OrderEmailHasProductEnabledCondition;
use WRCE\Dependencies\WordpressModels\Traits\SingletonTrait;

class OrderEmailOptions
{

    use SingletonTrait;

    private function __construct()
    {
        add_action('wrce_register_options', [$this, 'addDefaultOrderOptions']);

    }

    /**
     * @param RTMCustomEmail[] $emails
     * @return void
     */
    public function addDefaultOrderOptions(array $emails)
    {
        foreach ($emails as $email) {
            if ($email->getObjectType() !== 'order') {
                continue;
            }

            $email->addOption(OrderEmailHasProductEnabledCondition::class);
        }
    }


}