<?php

namespace RTMCustomMails;

class GeneratorArray implements \ArrayAccess, \Iterator, \Countable
{

    private array $generated = [];

    public function __construct(private array $array)
    {
    }

    public function offsetExists(mixed $offset): bool
    {
        return isset($this->array[$offset]);
    }

    public function offsetGet(mixed $offset): mixed
    {
        if (isset($this->generated[$offset])) {
            return $this->generated[$offset];
        }

        $value = $this->array[$offset] ?? null;
        if (is_callable($value)) {
            return $this->generated[$offset] = $value();
        }

        return $value;
    }

    public function offsetSet(mixed $offset, mixed $value): void
    {
        $this->array[$offset] = $value;
    }

    public function offsetUnset(mixed $offset): void
    {
        unset($this->array[$offset]);
    }

    public function current(): mixed
    {
        $current = current($this->array);

        if (is_callable($current)) {
            return $this->generated[key($this->array)] = $current();
        }

        return $current;
    }

    public function next(): void
    {
        next($this->array);
    }

    public function key(): mixed
    {
        return key($this->array);
    }

    public function valid(): bool
    {
        return key($this->array) !== null;
    }

    public function rewind(): void
    {
        reset($this->array);
    }

    public function count(): int
    {
        return count($this->array);
    }
}