<?php

namespace RTMMailComposer\ContextBuilder;

use RTMMailComposer\Model\CustomMail;

/**
 * @template T The object class
 * @class ObjectContextBuilder<T>
 */
abstract class AbstractObjectContextBuilder implements ContextBuilderInterface
{

    public function __construct(public string $objectType)
    {
    }

    public function getSubject(): string
    {
        return "object/$this->objectType";
    }

    /**
     * @inheritdoc
     */
    abstract public function prepareContext(CustomMail $mail, $mailObject, array $context = []): array;
}
