"use strict";
(self["webpackChunkwoocommerce_rtm_custom_emails"] = self["webpackChunkwoocommerce_rtm_custom_emails"] || []).push([[915],{

/***/ 28915:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

// ESM COMPAT FLAG
__webpack_require__.r(__webpack_exports__);

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  "default": () => (/* binding */ EmailSectionsListRoute)
});

// EXTERNAL MODULE: external "React"
var external_React_ = __webpack_require__(99196);
var external_React_default = /*#__PURE__*/__webpack_require__.n(external_React_);
// EXTERNAL MODULE: ./node_modules/react-router/dist/index.js
var dist = __webpack_require__(89250);
// EXTERNAL MODULE: ./node_modules/@material-tailwind/react/index.js
var react = __webpack_require__(59335);
// EXTERNAL MODULE: ./node_modules/lucide-react/dist/esm/icons/list-checks.js
var list_checks = __webpack_require__(75010);
// EXTERNAL MODULE: ./node_modules/lucide-react/dist/esm/icons/heading.js
var heading = __webpack_require__(16880);
// EXTERNAL MODULE: ./node_modules/lucide-react/dist/esm/icons/x.js
var x = __webpack_require__(41352);
// EXTERNAL MODULE: ./node_modules/lucide-react/dist/esm/icons/code.js
var code = __webpack_require__(12795);
// EXTERNAL MODULE: ./node_modules/classnames/index.js
var classnames = __webpack_require__(94184);
var classnames_default = /*#__PURE__*/__webpack_require__.n(classnames);
// EXTERNAL MODULE: ./assets/src/js/react/lib/rjsf/SchemaForm/index.tsx + 28 modules
var SchemaForm = __webpack_require__(1172);
;// CONCATENATED MODULE: ./assets/src/js/schema/email-section.schema.json
const email_section_schema_namespaceObject = JSON.parse('{"title":"Email Section","type":"object","properties":{"title":{"title":"Title","type":"string"},"enable":{"title":"Enable Section","type":"boolean"},"showTitle":{"title":"Show Title","type":"boolean"},"text":{"title":"Text","type":"string"},"condition":{"title":"Condition","$ref":"#/definitions/condition"}},"definitions":{"condition":{"type":"null"}}}');
;// CONCATENATED MODULE: ./assets/src/js/schema/email-section.uiSchema.json
const email_section_uiSchema_namespaceObject = JSON.parse('{"ui:options":{"fieldsetProperties":{"className":"form-grid grid-cols-2"},"submitButtonOptions":{"norender":true}},"title":{"classNames":"col-span-full"},"text":{"classNames":"col-span-full","ui:widget":"RichTextWidget"},"enable":{"classNames":"col-span-1"},"showTitle":{"classNames":"col-span-1"},"condition":{"classNames":"col-span-full","items":{"hideLabel":true,"function":{"title":"Function"},"arguments":{"hideLabel":true}}}}');
// EXTERNAL MODULE: ./assets/src/js/react/lib/datafetching/email.ts
var datafetching_email = __webpack_require__(21954);
// EXTERNAL MODULE: ./node_modules/lucide-react/dist/esm/icons/trash.js
var trash = __webpack_require__(13671);
;// CONCATENATED MODULE: ./assets/src/js/react/components/WhitelistTooltip.tsx



function WhitelistWords({ words }) {
    return (external_React_default().createElement("div", { className: "grid grid-cols-4 gap-1" }, words.map((word, index) => (external_React_default().createElement("span", { key: index }, word)))));
}
function WhitelistTooltip({ emailId }) {
    const { data, error, isLoading } = (0,datafetching_email/* useEmailVariableWhitelist */.Gc)(emailId);
    if (error) {
        return external_React_default().createElement("span", { className: 'text-red-500' },
            "Error: ",
            error.message);
    }
    return (external_React_default().createElement(react.Tooltip, { content: isLoading
            ? external_React_default().createElement(react.Spinner, null)
            : external_React_default().createElement(WhitelistWords, { words: data ?? [] }) },
        external_React_default().createElement("span", null, "Hover over me to see the variables!")));
}
/* harmony default export */ const components_WhitelistTooltip = (WhitelistTooltip);

;// CONCATENATED MODULE: ./assets/src/js/react/components/EmailSectionEdit.tsx








/* harmony default export */ const EmailSectionEdit = ((0,external_React_.forwardRef)(function ({ email, section, onSectionChange, onDelete }, ref) {
    const { data: conditionFunctionSchema } = (0,datafetching_email/* useConditionFunctions */.cq)(email);
    const memoizedData = external_React_default().useMemo(() => {
        return {
            ...section,
            condition: conditionFunctionSchema?.type === 'null' ? null : section.condition
        };
    }, [section, conditionFunctionSchema]);
    const memoizedSchema = external_React_default().useMemo(() => {
        const newSchema = structuredClone(email_section_schema_namespaceObject);
        if (!newSchema.definitions) {
            newSchema.definitions = {};
        }
        if (conditionFunctionSchema) {
            newSchema.definitions.condition = conditionFunctionSchema;
        }
        if (section.builtIn) {
            delete newSchema.properties.title;
            delete newSchema.properties.showTitle;
            delete newSchema.properties.text;
        }
        return newSchema;
    }, [conditionFunctionSchema]);
    const onChange = external_React_default().useCallback((data) => {
        const newSection = structuredClone(section);
        data.formData && Object.assign(newSection, data.formData);
        if (memoizedSchema.properties?.condition?.type === 'null') {
            newSection.condition = null;
        }
        onSectionChange(newSection);
    }, [section]);
    const omitEmptyNonRequiredFields = external_React_default().useCallback((formData, errors) => {
        if (!formData) {
            return errors;
        }
        Object.keys(formData).forEach((key) => {
            const value = formData[key];
            if (value === undefined || value === null || value === '' && memoizedSchema.required?.includes(key) === false) {
                delete formData[key];
            }
        });
        return errors;
    }, [memoizedSchema]);
    return external_React_default().createElement((external_React_default()).Fragment, null,
        external_React_default().createElement(react.Card, null,
            external_React_default().createElement("div", { className: 'absolute w-full flex justify-end' },
                external_React_default().createElement(react.Button, { color: 'red', className: '!p-2 flex-grow-0 !rounded-l-0', onClick: onDelete, title: 'Delete' },
                    external_React_default().createElement(trash/* default */.Z, { className: 'pr-1', size: 16 }))),
            external_React_default().createElement(react.CardBody, null,
                external_React_default().createElement(SchemaForm/* default */.Z, { idPrefix: section.id || 'new', schema: memoizedSchema, customValidate: omitEmptyNonRequiredFields, uiSchema: email_section_uiSchema_namespaceObject, data: memoizedData, onChange: onChange, ref: ref }),
                external_React_default().createElement("div", { style: { marginTop: '20px' } },
                    external_React_default().createElement(components_WhitelistTooltip, { emailId: email.id })))));
}));

;// CONCATENATED MODULE: ./assets/src/js/react/components/EmailSectionAccordion.tsx





/* harmony default export */ const EmailSectionAccordion = (external_React_default().forwardRef(function ({ open: _open, email, section, onSectionChange }, ref) {
    const [open, setOpen] = external_React_default().useState(_open ?? false);
    (0,external_React_.useEffect)(() => {
        const refObj = ref;
        if (refObj.current) {
            refObj.current.setOpen = setOpen;
        }
    }, [ref]);
    return external_React_default().createElement(react.Accordion, { open: open },
        external_React_default().createElement(react.AccordionHeader, { className: classnames_default()('text-base xl:text-lg py-3 px-2 anchor', {
                'text-gray-400': !section.enable,
            }), title: section.enable ? section.title : 'This section is disabled', onClick: () => setOpen(currentState => !currentState) },
            section.title,
            external_React_default().createElement("div", { className: 'text-end flex-grow group flex gap-2 justify-end' },
                Boolean(section.condition?.length) &&
                    external_React_default().createElement(list_checks/* default */.Z, { className: 'text-red-900 group-hover:text-red-700', "aria-label": 'This section is conditional' }),
                section.showTitle &&
                    external_React_default().createElement(heading/* default */.Z, { "aria-label": 'This displays its title' }),
                !section.enable &&
                    external_React_default().createElement(x/* default */.Z, { className: 'text-red-900 group-hover:text-red-700', "aria-label": 'This section is disabled' }),
                section.builtIn &&
                    external_React_default().createElement(code/* default */.Z, { "aria-label": 'Built-in section' }))),
        external_React_default().createElement(react.AccordionBody, { className: 'body' }, open && external_React_default().createElement(EmailSectionEdit, { email: email, section: section, onSectionChange: section => onSectionChange(section?.id, section), onDelete: () => onSectionChange(section.id), ref: ref })));
}));

// EXTERNAL MODULE: ./node_modules/react-sortablejs/dist/index.js
var react_sortablejs_dist = __webpack_require__(16941);
;// CONCATENATED MODULE: ./assets/src/js/react/components/EmailSectionsList/styles.module.scss
// extracted by mini-css-extract-plugin
/* harmony default export */ const styles_module = ({"chosen":"vB7Tojkh8WD83vEb06p0","ghost":"BZFBbvhZ7in7aIKyWaFC"});
// EXTERNAL MODULE: ./assets/src/js/react/lib/actions/email.ts
var actions_email = __webpack_require__(72926);
// EXTERNAL MODULE: ./node_modules/crypto-random-string/browser.js + 1 modules
var browser = __webpack_require__(45801);
// EXTERNAL MODULE: ./assets/src/js/react/lib/objectMod.ts
var objectMod = __webpack_require__(86560);
// EXTERNAL MODULE: ./node_modules/deep-object-diff/mjs/diff.js + 1 modules
var diff = __webpack_require__(41066);
// EXTERNAL MODULE: ./node_modules/react-select/dist/react-select.esm.js + 49 modules
var react_select_esm = __webpack_require__(25990);
// EXTERNAL MODULE: ./node_modules/js-convert-case/index.js
var js_convert_case = __webpack_require__(24417);
;// CONCATENATED MODULE: ./assets/src/js/react/components/AddTemplateSectionModal.tsx




function AddTemplateSectionModal({ open, builtInSections, isLoading, existingSections, onClose, onAddSection }) {
    const [selectedSection, setSelectedSection] = (0,external_React_.useState)();
    const availableSections = builtInSections.filter(section => !existingSections.some(existingSection => existingSection.id === section));
    const handleAddSection = () => {
        if (selectedSection) {
            onAddSection({ id: selectedSection, title: (0,js_convert_case.toSentenceCase)(selectedSection), builtIn: true });
            setSelectedSection(undefined);
        }
    };
    const handleClose = () => {
        setSelectedSection(undefined);
        onClose();
    };
    return (external_React_default().createElement(react.Dialog, { open: open, handler: handleClose },
        external_React_default().createElement(react.DialogBody, null,
            external_React_default().createElement(react_select_esm/* default */.ZP, { options: availableSections.map(section => ({ value: section, label: (0,js_convert_case.toSentenceCase)(section) })), isLoading: isLoading, onChange: (option) => {
                    setSelectedSection(option?.value);
                } })),
        external_React_default().createElement(react.DialogFooter, null,
            external_React_default().createElement(react.ButtonGroup, null,
                external_React_default().createElement(react.Button, { color: 'red', onClick: handleClose }, "Cancel"),
                external_React_default().createElement(react.Button, { color: 'green', onClick: handleAddSection }, "Add")))));
}
/* harmony default export */ const components_AddTemplateSectionModal = (AddTemplateSectionModal);

;// CONCATENATED MODULE: ./assets/src/js/react/components/EmailSectionsList/index.tsx












const toast = window.toast;
function cleanupSection(section) {
    return { ...(0,objectMod/* omit */.F)(section, 'chosen', 'ghost', 'selected', 'filtered'), text: section.text.trim() };
}
/* harmony default export */ function EmailSectionsList({ email, onEmailUpdated, onEmailChanged }) {
    const [sections, setSections] = external_React_default().useState(email.sections);
    const [hasChanges, setHasChanges] = external_React_default().useState(false);
    const [builtInSectionModalOpen, setBuiltInSectionModalOpen] = external_React_default().useState(false);
    const { data: builtInSections, isLoading: isLoadingBuiltInSections } = (0,datafetching_email/* useBuiltInSections */.S)();
    const [savingSections, setSavingSections] = external_React_default().useState(false);
    const { isLoading: isLoadingConditions, isValidating: isValidatingConditions } = (0,datafetching_email/* useConditionFunctions */.cq)(email);
    const [toastId, setToastId] = external_React_default().useState(null);
    const memoizedIsLoadingConditions = external_React_default().useMemo(() => isLoadingConditions || isValidatingConditions, [isLoadingConditions, isValidatingConditions]);
    const revalidateEmails = (0,datafetching_email/* useEmailsMutate */.zv)();
    (0,external_React_.useEffect)(() => {
        if (!toast) {
            return;
        }
        if (!Boolean(toastId) && memoizedIsLoadingConditions) {
            setToastId(toast.loading('Loading conditions...', { duration: Infinity }));
        }
        else if (toastId && !memoizedIsLoadingConditions) {
            toast.dismiss();
            setToastId(null);
        }
    }, [memoizedIsLoadingConditions, toastId]);
    const sectionRefs = (0,external_React_.useMemo)(() => sections
        .reduce((carry, section) => ({
        ...carry,
        [section.id]: external_React_default().createRef()
    }), {}), [sections]);
    const onSectionChange = external_React_default().useCallback((id, section) => {
        const newSections = structuredClone(sections);
        const index = newSections.findIndex((s) => s.id === id);
        if (index !== -1) {
            if (!section) {
                newSections.splice(index, 1);
            }
            else {
                newSections[index] = section;
            }
        }
        else if (section !== undefined) {
            newSections.push(section);
        }
        let cleanAndOrderedSections = newSections.map((section, index) => ({
            ...cleanupSection(section),
            sortOrder: index
        }));
        setSections(cleanAndOrderedSections);
    }, [sections]);
    const onSaveSections = external_React_default().useCallback(() => {
        setSavingSections(true);
        const invalidSectionEntries = Object.entries(sectionRefs).filter(([_, ref]) => {
            return !(ref.current?.validateForm() ?? true);
        });
        if (Boolean(invalidSectionEntries.length)) {
            toast.error('One or more sections are invalid. Please fix them before saving.');
            setSavingSections(false);
            invalidSectionEntries.forEach(([_, ref]) => {
                ref.current?.setOpen(true);
            });
            return;
        }
        (0,actions_email/* saveEmail */.it)({ ...email, sections })
            .catch((error) => {
            toast.error('Error saving email sections: ' + error.message);
        })
            .then((email) => {
            toast.success('Email sections saved', { duration: 3000 });
            onEmailUpdated({ ...email, sections: sections.map(cleanupSection) });
            setSections(email.sections);
        })
            .finally(() => {
            setSavingSections(false);
            revalidateEmails();
        });
    }, [email, sections]);
    const addSection = external_React_default().useCallback((section = undefined) => {
        let id = (0,browser/* default */.Z)({ length: 10, type: 'url-safe' });
        let newSection = {
            id: id,
            title: 'New section',
            text: '',
            enable: true,
            showTitle: false,
            sortOrder: 0,
            condition: [],
            builtIn: false,
            ...(section ?? {})
        };
        onSectionChange(id, newSection);
        setBuiltInSectionModalOpen(false);
    }, [sections]);
    const setList = external_React_default().useCallback((newSections) => {
        let cleanedAndOrderedSections = newSections.map((section, index) => ({
            ...cleanupSection(section),
            sortOrder: index
        }));
        setSections(cleanedAndOrderedSections);
    }, [sections]);
    (0,external_React_.useEffect)(() => {
        if (sections) {
            const cleanSections = sections.map(cleanupSection);
            onEmailChanged({ ...email, sections: cleanSections });
            let changes = (0,diff/* default */.Z)(email.sections.map(cleanupSection), cleanSections);
            setHasChanges(Boolean(Object.keys(changes).length));
        }
    }, [sections]);
    return external_React_default().createElement((external_React_default()).Fragment, null,
        external_React_default().createElement(react.ButtonGroup, { size: 'sm', color: 'white', fullWidth: true },
            external_React_default().createElement(react.Button, { type: 'button', onClick: () => setBuiltInSectionModalOpen(prev => !prev) }, "Add Template Section"),
            external_React_default().createElement(react.Button, { color: 'blue-gray', type: 'button', onClick: () => addSection() }, "Add section"),
            external_React_default().createElement(react.Button, { color: 'blue-gray', type: 'button', disabled: !hasChanges || savingSections, onClick: onSaveSections }, savingSections ?
                external_React_default().createElement("span", { className: 'inline-flex' },
                    external_React_default().createElement(react.Spinner, { className: 'w-4 h-4 pr-1' }),
                    "Saving...") : 'Save')),
        external_React_default().createElement(react_sortablejs_dist.ReactSortable, { list: sections, setList: setList, ghostClass: styles_module.ghost, chosenClass: styles_module.chosen, animation: 150, delay: 50, handle: '.anchor' }, sections.map((section) => external_React_default().createElement(EmailSectionAccordion, { key: email.id + '-' + section.id, email: email, section: section, onSectionChange: onSectionChange, ref: sectionRefs[section.id] }))),
        external_React_default().createElement(components_AddTemplateSectionModal, { open: builtInSectionModalOpen, builtInSections: builtInSections ?? [], isLoading: isLoadingBuiltInSections, existingSections: sections, onClose: () => setBuiltInSectionModalOpen(false), onAddSection: addSection }));
}

;// CONCATENATED MODULE: ./assets/src/js/react/routes/EmailSectionsListRoute.tsx



/* harmony default export */ function EmailSectionsListRoute() {
    const ctx = (0,dist/* useOutletContext */.bx)();
    const onUpdated = () => {
    };
    return external_React_default().createElement(EmailSectionsList, { key: ctx.email.id, email: ctx.email, onEmailChanged: onUpdated, onEmailUpdated: onUpdated });
}


/***/ })

}]);