"use strict";
(self["webpackChunkwoocommerce_rtm_custom_emails"] = self["webpackChunkwoocommerce_rtm_custom_emails"] || []).push([[881],{

/***/ 11881:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

// ESM COMPAT FLAG
__webpack_require__.r(__webpack_exports__);

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  "default": () => (/* binding */ DynamicSettings)
});

// EXTERNAL MODULE: external "React"
var external_React_ = __webpack_require__(99196);
var external_React_default = /*#__PURE__*/__webpack_require__.n(external_React_);
// EXTERNAL MODULE: ./node_modules/react-router/dist/index.js
var dist = __webpack_require__(89250);
// EXTERNAL MODULE: ./node_modules/@material-tailwind/react/index.js
var react = __webpack_require__(59335);
// EXTERNAL MODULE: ./assets/src/js/react/lib/actions/email.ts
var actions_email = __webpack_require__(72926);
// EXTERNAL MODULE: ./assets/src/js/react/lib/datafetching/email.ts
var datafetching_email = __webpack_require__(21954);
;// CONCATENATED MODULE: ./assets/src/js/schema/dynamic-settings.schema.json
const dynamic_settings_schema_namespaceObject = JSON.parse('{"type":"object","required":["title"],"properties":{"title":{"type":"string","title":"Email Title"},"description":{"type":"string","title":"Email Description"}}}');
;// CONCATENATED MODULE: ./assets/src/js/schema/dynamic-settings.uiSchema.json
const dynamic_settings_uiSchema_namespaceObject = JSON.parse('{"title":{"ui:placeholder":"Enter the email title"},"description":{"ui:placeholder":"Enter the email description"}}');
// EXTERNAL MODULE: ./node_modules/@rjsf/validator-ajv8/lib/index.js + 6 modules
var lib = __webpack_require__(27509);
// EXTERNAL MODULE: ./node_modules/@rjsf/core/lib/index.js + 55 modules
var core_lib = __webpack_require__(31642);
;// CONCATENATED MODULE: ./assets/src/js/react/components/DynamicEmailSettings.tsx









function DynamicEmailSettings({ email, disabled = false }) {
    const [submitting, setSubmitting] = (0,external_React_.useState)(false);
    const [formData, setFormData] = (0,external_React_.useState)({ title: email.title, description: email.description });
    const toast = window.toast;
    const revalidateEmails = (0,datafetching_email/* useEmailsMutate */.zv)();
    const navigate = (0,dist/* useNavigate */.s0)();
    (0,external_React_.useEffect)(() => {
        if (!email.isDynamic) {
            navigate(`/${email.id}/settings`);
        }
    }, [email, navigate]);
    const handleFormChange = (0,external_React_.useCallback)((e) => {
        setFormData(e.formData);
    }, []);
    const handleAddEmail = async ({ formData }) => {
        if (!formData.title.trim()) {
            toast.error("Email Title is required.");
            return;
        }
        setSubmitting(true);
        try {
            await (0,actions_email/* updateEmail */.s)({ id: email.id, ...formData });
            toast.success("Email updated successfully!");
        }
        catch (error) {
            toast.error(`Failed to update email: ${error.message}`);
        }
        finally {
            setSubmitting(false);
            await revalidateEmails();
        }
    };
    return (external_React_default().createElement(core_lib/* default */.ZP, { schema: dynamic_settings_schema_namespaceObject, uiSchema: dynamic_settings_uiSchema_namespaceObject, formData: formData, onChange: handleFormChange, onSubmit: handleAddEmail, validator: lib/* default */.ZP },
        external_React_default().createElement("button", { type: "submit", disabled: disabled || submitting, className: "bg-blue-500 text-white flex items-center justify-center w-full p-2 rounded" }, submitting ? external_React_default().createElement(react.Spinner, { className: "mr-2" }) : "Submit")));
}
/* harmony default export */ const components_DynamicEmailSettings = (DynamicEmailSettings);

;// CONCATENATED MODULE: ./assets/src/js/react/routes/DynamicEmailSettingsRoute.tsx



function DynamicSettings() {
    const ctx = (0,dist/* useOutletContext */.bx)();
    return (external_React_default().createElement(components_DynamicEmailSettings, { key: ctx.email.id, email: ctx.email }));
}


/***/ })

}]);