<?php

namespace RTMCustomMails\ContextBuilder;

use RTMMailComposer\ContextBuilder\ContextBuilderInterface;
use RTMMailComposer\Model\CustomMail;

abstract class AbstractContextBuilder implements ContextBuilderInterface
{
    protected readonly string $subjectType;

    public function __construct(string $subjectType)
    {
        $this->subjectType = $subjectType;
    }

    public function getSubject(): string
    {
        return $this->subjectType;
    }

    public function getWhitelist(): array
    {
        $baseWhitelist = $this->defineWhitelist();
        return apply_filters("wcre_whitelist_{$this->getSubject()}", $baseWhitelist);
    }

    public function prepareContext(CustomMail $mail, $mailObject, array $context = []): array
    {
        $preparedContext = $this->buildContext($mail, $mailObject, $context);
        return apply_filters("wcre_prepare_context_{$this->getSubject()}", $preparedContext, $mail, $mailObject, $context);
    }

    abstract protected function defineWhitelist(): array;

    abstract protected function buildContext(CustomMail $mail, $mailObject, array $context): array;
}

