<?php

namespace RTMCustomMails\ConditionProcessor;

use RTMCustomMails\SupportedObjectTypes;
use RTMMailComposer\ConditionProcessor\ConditionFunctionInterface;
use WC_Abstract_Order;

class OrderHasStatusCondition implements ConditionFunctionInterface
{

    public function __construct()
    {
    }

    public function getName(): string
    {
        return 'order_has_status';
    }

    public function getParameters(): array
    {
        $statuses = wc_get_order_statuses();
        $oneOf = array_map(fn($key, $value) => [
            'const' => $key,
            'title' => $value
        ], array_keys($statuses), array_values($statuses));

        return [
            'status' => [
                'title' => 'Order status',
                'type' => 'string',
                'required' => true,
                'oneOf' => $oneOf
            ]
        ];
    }


    public function evaluate(array $context): bool
    {
        $statusString = $context['status'] ?? '';
        /** @var WC_Abstract_Order|null $order */
        $order = $context['order'] ?? null;
        if ($order) {
            return $order->get_status() == $statusString;
        }
        return false;
    }

    public function getObjectType(): string
    {
        return SupportedObjectTypes::ORDER->value;
    }
}
