"use strict";
(self["webpackChunkwoocommerce_rtm_custom_emails"] = self["webpackChunkwoocommerce_rtm_custom_emails"] || []).push([[638],{

/***/ 88638:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

// ESM COMPAT FLAG
__webpack_require__.r(__webpack_exports__);

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  "default": () => (/* binding */ EmailLayout)
});

// EXTERNAL MODULE: external "React"
var external_React_ = __webpack_require__(99196);
var external_React_default = /*#__PURE__*/__webpack_require__.n(external_React_);
// EXTERNAL MODULE: ./node_modules/@material-tailwind/react/index.js
var react = __webpack_require__(59335);
// EXTERNAL MODULE: ./assets/src/js/react/lib/routing.tsx
var routing = __webpack_require__(41297);
// EXTERNAL MODULE: ./node_modules/react-router/dist/index.js
var dist = __webpack_require__(89250);
// EXTERNAL MODULE: ./node_modules/classnames/index.js
var classnames = __webpack_require__(94184);
var classnames_default = /*#__PURE__*/__webpack_require__.n(classnames);
// EXTERNAL MODULE: ./node_modules/react-select/dist/react-select.esm.js + 49 modules
var react_select_esm = __webpack_require__(25990);
// EXTERNAL MODULE: ./node_modules/js-convert-case/index.js
var js_convert_case = __webpack_require__(24417);
// EXTERNAL MODULE: ./assets/src/js/react/lib/datafetching/email.ts
var datafetching_email = __webpack_require__(21954);
;// CONCATENATED MODULE: ./assets/src/js/react/components/ObjectSearch.tsx




/* harmony default export */ function ObjectSearch({ objectType, onChange, selected }) {
    const [timerNumber, setTimerNumber] = (0,external_React_.useState)(0);
    const [searchString, setSearchString] = (0,external_React_.useState)('');
    const { data: foundObjects, isLoading: isSearchLoading } = (0,datafetching_email/* useObjectSearch */.Iy)(objectType, searchString);
    (0,external_React_.useEffect)(() => {
        if (!foundObjects?.length) {
            return;
        }
        if (!selected) {
            onChange(foundObjects[0]);
        }
    }, [foundObjects]);
    (0,external_React_.useEffect)(() => {
        if (objectType) {
            onChange(null);
        }
    }, [objectType]);
    const searchObjects = (0,external_React_.useCallback)((inputValue) => {
        if (!inputValue?.length || !objectType) {
            return;
        }
        if (timerNumber) {
            clearTimeout(timerNumber);
        }
        setTimerNumber(window.setTimeout(() => {
            setSearchString(inputValue);
        }, 750));
    }, [timerNumber]);
    return external_React_default().createElement(react_select_esm/* default */.ZP, { isDisabled: !objectType, id: 'search-courses', placeholder: `Search ${(0,js_convert_case.toSentenceCase)(objectType)}...`, className: 'w-full', classNames: {
            control: () => '!rounded-md',
            input: () => '!mh-0'
        }, isSearchable: true, value: foundObjects?.find(opt => opt.value == selected) ?? null, onInputChange: searchObjects, isLoading: isSearchLoading, options: foundObjects, onChange: evt => onChange(evt) });
}

;// CONCATENATED MODULE: ./assets/src/js/react/components/EmailPreviewFrame.tsx



/* harmony default export */ function EmailPreviewFrame({ email, objectId }) {
    const { isLoading, isValidating, error, data } = (0,datafetching_email/* useEmailPreview */.Jz)(email?.id, objectId);
    return external_React_default().createElement("div", { className: 'flex-1 text-center relative' },
        (isLoading || isValidating) &&
            external_React_default().createElement("div", { className: 'absolute flex justify-center w-full h-full bg-black bg-opacity-20' },
                external_React_default().createElement(react.Spinner, { className: 'mt-2' })),
        error && external_React_default().createElement("div", null,
            "Error: ",
            error.message),
        external_React_default().createElement("iframe", { className: 'w-full h-full', srcDoc: data?.content }));
}

// EXTERNAL MODULE: ./node_modules/@fortawesome/react-fontawesome/index.es.js
var index_es = __webpack_require__(67814);
// EXTERNAL MODULE: ./node_modules/@fortawesome/free-solid-svg-icons/index.mjs
var free_solid_svg_icons = __webpack_require__(59417);
;// CONCATENATED MODULE: ./assets/src/js/react/components/EmailPreview.tsx








function persistObjectSearch(objectType, id) {
    localStorage.setItem(`objectSearch-${objectType}`, id.toString());
}
function loadObjectSearch(objectType) {
    return objectType ? localStorage.getItem(`objectSearch-${objectType}`) : null;
}
/* harmony default export */ function EmailPreview({ email, className }) {
    const [selectedPreviewObject, setSelectedPreviewObject] = external_React_default().useState(loadObjectSearch(email.objectType));
    const onSetObjectSearch = (id) => {
        if (email && id) {
            persistObjectSearch(email.objectType, id);
        }
        setSelectedPreviewObject(id);
    };
    const { mutate } = (0,datafetching_email/* useEmailPreview */.Jz)(email.id, selectedPreviewObject);
    return (external_React_default().createElement("div", { className: classnames_default()(`flex flex-col h-full`, className) },
        external_React_default().createElement("div", { className: 'flex w-full items-center' },
            external_React_default().createElement(ObjectSearch, { objectType: email.objectType, onChange: opt => onSetObjectSearch(opt?.value ?? null), selected: selectedPreviewObject }),
            external_React_default().createElement(react.Button, { color: 'white', size: 'sm', onClick: () => mutate() },
                external_React_default().createElement(index_es/* FontAwesomeIcon */.G, { icon: free_solid_svg_icons/* faRedo */.XSV }))),
        external_React_default().createElement(EmailPreviewFrame, { key: email.objectType, email: email, objectId: selectedPreviewObject })));
}

;// CONCATENATED MODULE: ./assets/src/js/react/layout/EmailLayout.tsx









/* harmony default export */ function EmailLayout() {
    const { email } = (0,dist/* useOutletContext */.bx)();
    const routeId = (0,routing/* useRouteId */.P)();
    const navigate = (0,dist/* useNavigate */.s0)();
    const [tab, setTab] = external_React_default().useState('config');
    const onClickTab = (value) => {
        navigate(`/${email.id}/${value}`);
    };
    return external_React_default().createElement((external_React_default()).Fragment, null,
        external_React_default().createElement(react.Tabs, { value: tab, className: '2xl:hidden' },
            external_React_default().createElement(react.TabsHeader, null,
                external_React_default().createElement(react.Tab, { value: 'config', onClick: () => setTab('config') },
                    external_React_default().createElement(index_es/* FontAwesomeIcon */.G, { icon: free_solid_svg_icons/* faCogs */.Kb6 })),
                external_React_default().createElement(react.Tab, { value: 'preview', onClick: () => setTab('preview') },
                    external_React_default().createElement(index_es/* FontAwesomeIcon */.G, { icon: free_solid_svg_icons/* faEye */.Mdf })))),
        external_React_default().createElement("div", { className: 'flex h-full min-h-[80vh]' },
            external_React_default().createElement("div", { className: classnames_default()('2xl:w-full overflow-hidden transition-all duration-300 whitespace-nowrap', {
                    'w-full': tab === 'config',
                    'w-0': tab === 'preview'
                }) },
                external_React_default().createElement(react.Tabs, { value: routeId },
                    external_React_default().createElement(react.TabsHeader, null,
                        external_React_default().createElement(react.Tab, { value: 'sections', onClick: () => onClickTab('sections') },
                            external_React_default().createElement(index_es/* FontAwesomeIcon */.G, { className: 'pr-1', icon: free_solid_svg_icons/* faFileCode */.w49 }),
                            "Sections"),
                        external_React_default().createElement(react.Tab, { value: 'attachments', onClick: () => onClickTab('attachments') },
                            external_React_default().createElement(index_es/* FontAwesomeIcon */.G, { className: 'pr-1', icon: free_solid_svg_icons/* faPaperclip */.Alc }),
                            "Attachments"),
                        external_React_default().createElement(react.Tab, { value: 'settings', onClick: () => onClickTab('settings') },
                            external_React_default().createElement(index_es/* FontAwesomeIcon */.G, { className: 'pr-1', icon: free_solid_svg_icons/* faCogs */.Kb6 }),
                            "Settings"))),
                external_React_default().createElement(dist/* Outlet */.j3, { context: { email } })),
            external_React_default().createElement("div", { className: classnames_default()('2xl:w-full overflow-hidden transition-all duration-300 whitespace-nowrap', {
                    'w-full': tab === 'preview',
                    'w-0': tab === 'config'
                }) },
                external_React_default().createElement(EmailPreview, { email: email }))));
}


/***/ })

}]);