"use strict";
(self["webpackChunkwoocommerce_rtm_custom_emails"] = self["webpackChunkwoocommerce_rtm_custom_emails"] || []).push([[474],{

/***/ 8474:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

// ESM COMPAT FLAG
__webpack_require__.r(__webpack_exports__);

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  "default": () => (/* binding */ EmailSettingsRoute)
});

// EXTERNAL MODULE: external "React"
var external_React_ = __webpack_require__(99196);
var external_React_default = /*#__PURE__*/__webpack_require__.n(external_React_);
// EXTERNAL MODULE: ./node_modules/react-router/dist/index.js
var dist = __webpack_require__(89250);
// EXTERNAL MODULE: ./assets/src/js/react/lib/datafetching/email.ts
var datafetching_email = __webpack_require__(21954);
// EXTERNAL MODULE: ./assets/src/js/react/lib/rjsf/SchemaForm/index.tsx + 29 modules
var SchemaForm = __webpack_require__(63610);
;// CONCATENATED MODULE: ./assets/src/js/schema/settings.uiSchema.json
const settings_uiSchema_namespaceObject = JSON.parse('{"ui:submitButtonOptions":{"props":{"className":"self-end"}},"trigger_hooks":{"ui:widget":"multiselect"}}');
// EXTERNAL MODULE: ./node_modules/@material-tailwind/react/index.js
var react = __webpack_require__(59335);
// EXTERNAL MODULE: ./assets/src/js/react/lib/actions/email.ts
var actions_email = __webpack_require__(72926);
// EXTERNAL MODULE: ./node_modules/@fortawesome/react-fontawesome/index.es.js
var index_es = __webpack_require__(67814);
// EXTERNAL MODULE: ./node_modules/@fortawesome/free-solid-svg-icons/index.mjs
var free_solid_svg_icons = __webpack_require__(59417);
;// CONCATENATED MODULE: ./assets/src/js/react/components/EmailSettings.tsx








const { toast } = window;
const isEmptyValue = (value) => {
    return !value
        || (Array.isArray(value) && value.length === 0)
        || (typeof value === 'object' && Object.keys(value).length === 0)
        || value === '';
};
/* harmony default export */ function EmailSettings({ email, onEmailUpdated, disabled = false }) {
    const mutate = (0,datafetching_email/* useEmailMutate */.FX)();
    const [submitting, setSubmitting] = external_React_default().useState(false);
    const { data: schema, isLoading: isLoadingSchema } = (0,datafetching_email/* useEmailSettingsSchema */.J$)(email);
    const [exporting, setExporting] = external_React_default().useState(false);
    const [importing, setImporting] = external_React_default().useState(false);
    const importRef = external_React_default().useRef(null);
    const [settings, setSettings] = external_React_default().useState(email.settings ?? {});
    const saveSettings = (data) => {
        setSubmitting(true);
        (0,actions_email/* saveEmail */.it)({ ...email, settings: data })
            .catch((error) => {
            toast.error('Error saving email sections: ' + error.message);
        })
            .then((email) => {
            toast.success('Email sections saved', { duration: 3000 });
            onEmailUpdated(email);
        })
            .finally(() => setSubmitting(false));
    };
    const exportSettings = () => {
        setExporting(true);
        (0,actions_email/* exportEmail */.Cu)(email)
            .then(response => {
            const a = document.createElement("a");
            const file = new Blob([JSON.stringify(response)], { type: 'text/plain' });
            a.href = URL.createObjectURL(file);
            a.download = 'export-' + email.id + '.json';
            a.click();
        })
            .catch(err => toast.error(`Error exporting email settings: ${err.message}`))
            .finally(() => setExporting(false));
    };
    const importSettings = () => {
        setImporting(true);
        const response = confirm("Importing email settings will overwrite your current settings. Make sure you have a backup of your current settings. Do you want to continue?");
        if (!response) {
            setImporting(false);
            return;
        }
        importRef.current?.click();
    };
    const onFileInput = (0,external_React_.useCallback)((e) => {
        const file = e.target.files?.[0];
        if (file) {
            const reader = new FileReader();
            reader.onload = (evt) => {
                const content = evt.target?.result;
                try {
                    const data = JSON.parse(content);
                    (0,actions_email/* importEmail */.KH)(email, data)
                        .then((email) => mutate(email))
                        .catch((error) => toast.error('Error importing email settings: ' + error.message))
                        .finally(() => setImporting(false));
                }
                catch (e) {
                    toast.error('Error reading file: ' + (e instanceof Error ? e.message : 'Unknown error'));
                }
            };
            reader.readAsText(file);
        }
    }, [email]);
    const suppressEmptyOptionalObjectError = (0,external_React_.useCallback)((errors) => {
        function shouldSuppressError(formData, error) {
            if (error.name === 'required' && error.property) {
                const parentFieldId = error.property
                    .replace(`['${error.params.missingProperty}']`, '')
                    .replace("['", '')
                    .replace("']", '');
                const parentFieldValue = formData[parentFieldId];
                return Boolean(parentFieldId) && JSON.stringify(parentFieldValue) === '{}';
            }
            if (error.property && isEmptyValue(settings[error.property])) {
                return true;
            }
            return false;
        }
        return errors.filter(error => !shouldSuppressError(settings, error));
    }, [settings]);
    return external_React_default().createElement((external_React_default()).Fragment, null,
        isLoadingSchema && external_React_default().createElement("div", { className: 'flex justify-center mb-2' },
            external_React_default().createElement(react.Spinner, null)),
        external_React_default().createElement(SchemaForm/* default */.Z, { disabled: disabled || isLoadingSchema || submitting, schema: schema ?? {}, uiSchema: settings_uiSchema_namespaceObject, data: settings, transformErrors: suppressEmptyOptionalObjectError, onSubmit: saveSettings, onChange: ({ formData }) => {
                setSettings(formData);
            }, submitLabel: submitting ? 'Saving...' : 'Save' }),
        external_React_default().createElement(react.ButtonGroup, { size: 'sm', color: 'white', fullWidth: true, className: 'mt-2' },
            external_React_default().createElement(react.Button, { onClick: importSettings, className: 'border border-gray-200 inline-flex justify-center', disabled: importing },
                external_React_default().createElement(index_es/* FontAwesomeIcon */.G, { icon: free_solid_svg_icons/* faFileUpload */.Y9i, className: 'pr-1' }),
                importing ? external_React_default().createElement(react.Spinner, { className: 'w-4 h-4 pr-1' }) : 'Import'),
            external_React_default().createElement(react.Button, { onClick: exportSettings, className: 'border border-gray-200 inline-flex justify-center', disabled: exporting },
                external_React_default().createElement(index_es/* FontAwesomeIcon */.G, { icon: free_solid_svg_icons/* faFileDownload */.kwI, className: 'pr-1' }),
                exporting ? external_React_default().createElement(react.Spinner, { className: 'w-4 h-4 pr-1' }) : 'Export')),
        external_React_default().createElement("input", { type: 'file', accept: 'application/json', className: 'hidden', onInput: onFileInput, ref: importRef }));
}

;// CONCATENATED MODULE: ./assets/src/js/react/routes/EmailSettingsRoute.tsx




/* harmony default export */ function EmailSettingsRoute() {
    const revalidateAll = (0,datafetching_email/* useEmailsMutate */.zv)();
    const ctx = (0,dist/* useOutletContext */.bx)();
    const onUpdated = () => {
        revalidateAll();
    };
    return external_React_default().createElement(EmailSettings, { key: ctx.email.id, email: ctx.email, onEmailUpdated: onUpdated });
}


/***/ })

}]);