<?php

namespace RTMCustomMails\EmailSections\Defaults;

class CustomerRefundedOrderDefaultTemplate implements DefaultTemplateInterface
{

    /**
     * Returns the email id asociated with this template
     * @return string
     */
    public static function getEmailId(): string
    {
        return 'customer_refunded_order';
    }

    /**
     * Returns the default sections for this email
     * @return array EmailSection[]
     */
    public static function getDefaultSections(): array
    {
        return [
            [
                'id' => 'woocommerce_email_header',
                'enable' => true,
                'title' => 'Header',
                'showTitle' => false,
                'text' => '',
                'condition' => [],
                'sortOrder' => 0,
            ],
            [
                'id' => 'greeting',
                'enable' => true,
                'title' => 'Greeting',
                'showTitle' => false,
                'text' => esc_html__('Hi {{ billing_first_name }},', 'woocommerce'),
                'condition' => [],
                'sortOrder' => 2,
            ],
            [
                'id' => 'main_text',
                'enable' => true,
                'title' => 'Main Text',
                'showTitle' => true,
                'text' => <<<TWIG
{% if partial_refund %}
    Your order on {{ site_title }} has been partially refunded. There are more details below for your reference:
{% else %}
    Your order on {{ site_title }} has been refunded. There are more details below for your reference:
{% endif %}
TWIG,
                'condition' => [],
                'sortOrder' => 2,
            ],
            [
                'id' => 'woocommerce_email_order_details',
                'enable' => true,
                'title' => 'Order Details',
                'showTitle' => false,
                'text' => '',
                'condition' => [],
                'sortOrder' => 3,
            ],
            [
                'id' => 'woocommerce_email_order_meta',
                'enable' => true,
                'title' => 'Order Meta',
                'showTitle' => false,
                'text' => '',
                'condition' => [],
                'sortOrder' => 3,
            ],
            [
                'id' => 'woocommerce_email_customer_details',
                'enable' => true,
                'title' => 'Customer Details',
                'showTitle' => false,
                'text' => '',
                'condition' => [],
                'sortOrder' => 4,
            ],
            [
                'id' => 'woocommerce_email_additional_content',
                'enable' => true,
                'title' => 'Additional Content',
                'showTitle' => false,
                'text' => '',
                'condition' => [],
                'sortOrder' => 5,
            ],
            [
                'id' => 'woocommerce_email_footer',
                'enable' => true,
                'title' => 'Footer',
                'showTitle' => false,
                'text' => '',
                'condition' => [],
                'sortOrder' => 6,
            ]
        ];
    }
}
