<?php
/**
 * Plugin Name: WooCommerce RTM Custom Emails
 * Description: Plugin to add any custom emails.
 * Author: RTM Business
 * Version: v0.3.0-RC.1
 * Requires PHP: 8.1
 * Required Plugins: woocommerce
 */

use RTMCustomMails\Core;

if (!defined('ABSPATH')) exit; // Exit if accessed directly

define('WRCE_ROOT_PATH', plugin_dir_path(__FILE__));
define('WRCE_ROOT_URL', plugin_dir_url(__FILE__));

define('WRCE_ASSETS_PATH', plugin_dir_path(__FILE__) . 'assets');
define('WRCE_ASSETS_URL', plugin_dir_url(__FILE__) . 'assets');

define('WRCE_VERSION', 'v0.3.0-RC.1');

if (!class_exists('RTMCustomMails\Core')) {
    require_once plugin_dir_path(__FILE__) . 'vendor/autoload.php';
}

if (!function_exists('array_diff_assoc_recursive')) {
    function array_diff_assoc_recursive($aArray1, $aArray2) {
        $aReturn = array();

        foreach ($aArray1 as $mKey => $mValue) {
            if (array_key_exists($mKey, $aArray2)) {
                if (is_array($mValue)) {
                    $aRecursiveDiff = array_diff_assoc_recursive($mValue, $aArray2[$mKey]);
                    if (count($aRecursiveDiff)) { $aReturn[$mKey] = $aRecursiveDiff; }
                } else {
                    if ($mValue != $aArray2[$mKey]) {
                        $aReturn[$mKey] = $mValue;
                    }
                }
            } else {
                $aReturn[$mKey] = $mValue;
            }
        }
        return $aReturn;
    }
}

$core = Core::instance();

//register activation hook
register_activation_hook(__FILE__, [$core, 'activatePlugin']);
