<?php

namespace RTMCustomMails\ContextBuilder;

use RTMMailComposer\Model\CustomMail;

class CustomerContextBuilder extends RecipientTypeContextBuilder
{
    public function __construct()
    {
        // appropriate recipient type.
        parent::__construct('customer');
    }

    /**
     * Define the whitelist specific to customer context.
     * This function is required since defineWhitelist() is an abstract method in AbstractContextBuilder.
     */
    protected function defineWhitelist(): array
    {
        // List all the variables that should be whitelisted for the customer emails.
        return [
            'recipient_name',
        ];
    }

    /**
     * Build the context for the customer emails.
     * This function is required to implement the abstract method buildContext() from AbstractContextBuilder.
     *
     * @param CustomMail $mail
     * @param mixed $mailObject Could be an order, user, or any relevant object.
     * @param array $context Initial context array, may include predefined variables.
     * @return array The context array populated with additional data.
     */
    protected function buildContext(CustomMail $mail, $mailObject, array $context = []): array
    {
        if (($context['order'] ?? null) instanceof \WC_Order) {
            $order = $context['order'];
            $context['recipient_name'] = $order->get_billing_first_name() ?: $order->get_billing_email() ?: 'Customer';
        } elseif (($context['user'] ?? null) instanceof \WP_User) {
            /** @var \WP_User $user */
            $user = $context['user'];
            $context['recipient_name'] = $user->first_name ?: $user->display_name;
        } else {
            $context['recipient_name'] = (get_bloginfo('name') . ' Customer');
        }
        return $context;
    }
}
