<?php

namespace RTMCustomMails\ContextBuilder;

use RTMMailComposer\Model\CustomMail;

class AdminContextBuilder extends RecipientTypeContextBuilder
{
    public function __construct()
    {
        parent::__construct('admin');
    }

    protected function defineWhitelist(): array
    {
        return [
            'user',
            'recipient_name',
        ];
    }

    protected function buildContext(CustomMail $mail, $mailObject, array $context = []): array
    {
        $user = $context['user'] ?? get_user_by('email', get_option('admin_email'));
        $context['recipient_name'] = trim($user->first_name . ' ' . $user->last_name) ?: $user->display_name;
        return $context;
    }
}
