<?php

namespace WordpressModels\Rest\Permissions;

use WP_User;

class WordpressPermissionFunctions implements PermissionFunctionsInterface
{

    public static function isAuthorized(): bool
    {
        return is_user_logged_in();
    }

    public static function userHasRole(string $role, ?int $userId = null): bool
    {
        if (!$userId) {
            $userId = get_current_user_id();
        }
        return in_array($role, (new WP_User($userId))->roles);
    }

    public static function userHasCapability(string $capability, ?int $userId = null, ...$args): bool
    {
        if (!$userId) {
            $userId = get_current_user_id();
        }
        return user_can($userId, $capability, ...$args);
    }
}