<?php

namespace WordpressModels\Rest\Permissions;

use Symfony\Component\ExpressionLanguage\ExpressionFunction;
use Symfony\Component\ExpressionLanguage\ExpressionFunctionProviderInterface;

class RoleExpressionFunctionProvider implements ExpressionFunctionProviderInterface
{

    public function __construct(private readonly PermissionFunctionsInterface $permissionFunctions)
    {
    }

    public function compile(...$args): string
    {
        $class = $this->permissionFunctions::class;
        return sprintf('\%s(%s)', "$class::userHasCapability", implode(', ', $args));
    }

    public function evaluate($args, $role): bool
    {
        return $this->permissionFunctions::userHasRole($role);
    }

    public function getFunctions(): array
    {
        return [
            new ExpressionFunction('role', $this->compile(...), $this->evaluate(...)),
        ];
    }
}