<?php

namespace WordpressModels\Rest\Permissions;

use Symfony\Component\ExpressionLanguage\ExpressionFunction;
use Symfony\Component\ExpressionLanguage\ExpressionFunctionProviderInterface;

class CapabilityExpressionFunctionProvider implements ExpressionFunctionProviderInterface
{

    public function __construct(private readonly PermissionFunctionsInterface $permissionFunctions)
    {
    }

    public function compile(...$args): string
    {
        $class = $this->permissionFunctions::class;
        return sprintf('\%s(%s)', "$class::userHasCapability", implode(', ', $args));
    }

    public function evaluate($_args, string $capability, ...$args): bool
    {
        return $this->permissionFunctions::userHasCapability($capability, get_current_user_id(), ...$args);
    }

    public function getFunctions(): array
    {
        return [
            new ExpressionFunction('capability', $this->compile(...), $this->evaluate(...)),
        ];
    }
}