<?php

namespace WordpressModels\ORM\WooCommerceEntity;

use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;
use Symfony\Component\Serializer\Attribute\Groups;
use WordpressModels\ORM\Entity\AbstractMeta;

#[ORM\Entity]
#[ORM\Table(name: "orders_meta")]
class OrderMeta extends AbstractMeta
{


    #[ORM\Column(name: 'id', type: Types::BIGINT, options: ['unsigned' => true])]
    #[ORM\Id]
    #[ORM\GeneratedValue(strategy: 'IDENTITY')]
    #[Groups('read_meta')]
    protected ?int $id = null;

    /**
     * Foreign key to the order
     * @return string
     */
    #[ORM\ManyToOne(targetEntity: Order::class, inversedBy: 'meta')]
    private Order $order;

    public function getOrder(): Order
    {
        return $this->order;
    }

    public function setOrder(Order $order): void
    {
        $this->order = $order;
    }

    public static function getType(): string
    {
        return 'wc_order';
    }
}