<?php
/*
 * Copyright (c) 2023. RTM Business
 */

namespace WordpressModels\ORM\EntityTrait;

use DateTime;
use Doctrine\ORM\Events;
use Doctrine\ORM\Mapping\Column;
use Symfony\Component\Serializer\Annotation\Groups;
use WordpressModels\ORM\Attributes\Timestamp;

trait SoftDeletable
{

    #[Column(type: 'datetime', nullable: true)]
    #[Groups(['read_timestamps'])]
    #[Timestamp(Events::preRemove)]
    protected ?DateTime $deletedAt = null;


    /**
     * @return DateTime|null
     */
    public function getDeletedAt(): ?DateTime
    {
        return $this->deletedAt;
    }

    /**
     * @param DateTime|null $deletedAt
     * @return self
     */
    public function setDeletedAt(?DateTime $deletedAt): self
    {
        $this->deletedAt = $deletedAt;
        return $this;
    }
}