<?php

namespace RTMCustomMails\ContextBuilder;

use RTMMailComposer\Model\CustomMail;

class CustomerContextBuilder extends RecipientTypeContextBuilder
{

    public function __construct()
    {
        parent::__construct('customer');
    }

    /**
     * @inheritDoc
     */
    public function prepareContext(CustomMail $mail, $mailObject, array $context = []): array
    {
        if (($context['order'] ?? null) instanceof \WC_Order) {
            $order = $context['order'];
            $context['recipient_name'] = $order->get_billing_first_name() ?: $order->get_billing_email() ?: 'Customer';
        } elseif (($context['user'] ?? null) instanceof \WP_User) {
            /** @var \WP_User $user */
            $user = $context['user'];
            $context['recipient_name'] = $user->first_name ?: $user->display_name;
        } else {
            $context['recipient_name'] = $context['billing_first_name'] ?? ''
                ?: $context['user_login'] ?? ''
                    ?: (get_bloginfo('name') . ' Customer');
        }
        return $context;
    }

    public function getWhitelist(): array
    {
        return [
            'recipient_name',
        ];
    }
}