<?php

namespace RTMCustomMails\ConditionProcessor;

use RTMMailComposer\ConditionProcessor\ConditionFunctionInterface;
use WC_Abstract_Order;

class UserFirstTimeCustomerCondition implements ConditionFunctionInterface
{
    public function __construct()
    {
    }

    public function getName(): string
    {
        return 'is_first_time_customer';
    }

    public function getParameters(): array
    {
        return [];
    }

    public function evaluate(array $context): bool
    {
        /** @var WC_Abstract_Order|null $order */
        $order = $context['order'] ?? null;
        if (!$order) {
            return false;
        }

        // Checking if this is the first order placed by the customer
        $customer_orders = wc_get_orders(['customer_id' => $order->get_customer_id(), 'limit' => 1]);
        return count($customer_orders) === 1;
    }

    public function getObjectType(): string
    {
        return SupportedObjectTypes::ORDER->value;
    }
}
