<?php

namespace RTMCustomMails\ConditionProcessor;

use RTMCustomMails\SupportedObjectTypes;
use RTMMailComposer\ConditionProcessor\ConditionFunctionInterface;
use WC_Abstract_Order;

class OrderHasFreeItemCondition implements ConditionFunctionInterface
{
    public function __construct()
    {
    }

    public function getName(): string
    {
        return 'order_has_free_item';
    }

    public function getParameters(): array
    {
        return [];
    }

    public function evaluate(array $context): bool
    {
        /** @var WC_Abstract_Order|null $order */
        $order = $context['order'] ?? null;

        if (!$order) {
            return false;
        }

        return $order->has_free_item();
    }

    public function getObjectType(): string
    {
        return SupportedObjectTypes::ORDER->value;
    }
}
