<?php

namespace RTMCustomMails\ConditionProcessor;

use RTMMailComposer\ConditionProcessor\ConditionFunctionInterface;
use WC_Abstract_Order;

class OrderHasDownloadableItemCondition implements ConditionFunctionInterface
{
    public function __construct()
    {
    }

    public function getName(): string
    {
        return 'order_has_downloadable_item';
    }

    public function getParameters(): array
    {
        return [];
    }

    public function evaluate(array $context): bool
    {
        /** @var WC_Abstract_Order|null $order */
        $order = $context['order'] ?? null;
        if (!$order) {
            return false;
        }

        return $order->has_downloadable_item();
    }

    public function getObjectType(): string
    {
        return SupportedObjectTypes::ORDER->value;
    }
}
