<?php

namespace RTMMailComposer\ContextBuilder;

use RTMMailComposer\Model\CustomMail;

/**
 * @template T The object, may be any type
 * @interface ContextBuilderInterface<T>
 */
interface ContextBuilderInterface
{

    public function getSubject(): string;

    /**
     * Prepares the context for the rendering of the email
     *
     * @param CustomMail $mail
     * @param T $mailObject The object to be used in preparing the context
     * @param array $context The initial context
     *
     * @return array The prepared context
     */
    public function prepareContext(CustomMail $mail, $mailObject, array $context = []): array;

    public function getWhitelist(): array;

}
