<?php

namespace RTMMailComposer\ConditionProcessor;

interface ConditionFunctionInterface
{

    public function __construct();

    /**
     * The object type for this function
     * @return string
     */
    public function getObjectType(): string;

    /**
     * The expression function name.
     * @return string
     */
    public function getName(): string;

    /**
     * Define the parameters for the function as JSON Schema (2020-12)
     *
     * @return array{name: string, type: string}[]
     */
    public function getParameters(): array;

    /**
     * The function evaluation.
     *
     * @param array $context the parameters as described in `self::getParameters()`, pre-validated.
     * @return bool
     */
    public function evaluate(array $context): bool;

//    public static function compile(...$args): string;
}