<?php

namespace RTMMailComposer\ConditionProcessor;

use Symfony\Component\ExpressionLanguage\ExpressionLanguage;

class ConditionExpressionLanguage
{

    private ExpressionLanguage $language;

    public function __construct()
    {
        $this->language = new ExpressionLanguage();
    }


    /**
     * Evaluates the given expression using the defined expression language
     * @param string $expression
     * @param array $params
     *
     * @return bool
     */
    public function evaluate(string $expression, array $params): bool
    {
        return $this->language->evaluate($expression, $params);
    }

    /**
     * @return ExpressionLanguage
     */
    public function getLanguage(): ExpressionLanguage
    {
        return $this->language;
    }
}
