<?php
/*
 * Copyright (c) 2023. RTM Business
 */

namespace WordpressModels\ORM\WooCommerceEntity;


use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;

/**
 * Doctrine entity matching the `wp_woocommerce_log` table.
 *
 * Columns:
 * log_id
 * timestamp
 * level
 * source
 * message
 * context
 */
#[Entity]
#[Table(name: 'log')]
class Log
{

    #[Id]
    #[Column(name: 'log_id', type: Types::BIGINT, options: ['unsigned' => true])]
    #[GeneratedValue(strategy: 'IDENTITY')]
    private ?int $id = null;

    #[Column(name: 'timestamp', type: Types::BIGINT, options: ['unsigned' => true])]
    private int $timestamp;

    #[Column(name: 'level', type: Types::STRING, length: 20)]
    private string $level;

    #[Column(name: 'source', type: Types::STRING, length: 20)]
    private string $source;

    #[Column(name: 'message', type: Types::TEXT)]
    private string $message;

    #[Column(name: 'context', type: Types::TEXT)]
    private string $context;

    /**
     * @return int|null
     */
    public function getId(): ?int
    {
        return $this->id;
    }

    /**
     * @param int|null $id
     * @return Log
     */
    public function setId(?int $id): Log
    {
        $this->id = $id;
        return $this;
    }

    /**
     * @return int
     */
    public function getTimestamp(): int
    {
        return $this->timestamp;
    }

    /**
     * @param int $timestamp
     * @return Log
     */
    public function setTimestamp(int $timestamp): Log
    {
        $this->timestamp = $timestamp;
        return $this;
    }

    /**
     * @return string
     */
    public function getLevel(): string
    {
        return $this->level;
    }

    /**
     * @param string $level
     * @return Log
     */
    public function setLevel(string $level): Log
    {
        $this->level = $level;
        return $this;
    }

    /**
     * @return string
     */
    public function getSource(): string
    {
        return $this->source;
    }

    /**
     * @param string $source
     * @return Log
     */
    public function setSource(string $source): Log
    {
        $this->source = $source;
        return $this;
    }

    /**
     * @return string
     */
    public function getMessage(): string
    {
        return $this->message;
    }

    /**
     * @param string $message
     * @return Log
     */
    public function setMessage(string $message): Log
    {
        $this->message = $message;
        return $this;
    }

    /**
     * @return string
     */
    public function getContext(): string
    {
        return $this->context;
    }

    /**
     * @param string $context
     * @return Log
     */
    public function setContext(string $context): Log
    {
        $this->context = $context;
        return $this;
    }

}