<?php

namespace WordpressModels\DependencyInjection\Pages;

use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\DependencyInjection\Extension\Extension;
use WordpressModels\DependencyInjection\Pages\PageRegistry;
use WordpressModels\Page\AsyncPageData;
use WordpressModels\Page\PageInterface;

/**
 * Page extension.
 *
 * Registers all services implementing the PageInterface.
 *
 * @since 0.6.0
 */
class PagesExtension extends Extension
{
    public function load(array $configs, ContainerBuilder $container)
    {
        $container->registerForAutoconfiguration(PageInterface::class)
            ->addTag('wpm_page');

        // add the registry
        $container->register(PageRegistry::class)
            ->setPublic(true)
            ->setAutowired(true)
            ->setAutoconfigured(true);

        // add ajax page data service
        $container->register(AsyncPageData::class)
            ->setPublic(true)
            ->setAutowired(true)
            ->setAutoconfigured(true);
    }
}