<?php

namespace WordpressModels\DependencyInjection\HookAttributes\Attributes;

#[\Attribute(\Attribute::TARGET_METHOD | \Attribute::TARGET_CLASS | \Attribute::IS_REPEATABLE)]
class Action extends Hook
{

    /**
     * @param string $hook -- The hook to register
     * @param int $priority -- The priority of the hook
     * @param int|null $accepted_args -- The number of arguments the hook accepts
     * @param string|null $when -- The hook to register this hook on
     * @param bool $admin -- Whether the hook should only be registered in the admin
     */
    public function __construct(string $hook,
                                int $priority = 10,
                                ?int $accepted_args = null,
                                ?string $when = null,
                                bool $admin = false)
    {
        parent::__construct('action', $hook, $priority, $accepted_args, $when, $admin);
    }

}