<?php

namespace RTMCustomMails\WooCommerce;

use WordpressModels\Traits\SingletonTrait;

class WooCommerceTemplate
{

    use SingletonTrait;

    public function __construct()
    {
        add_filter('woocommerce_locate_template', [$this, 'tryLocateWoocommerceTemplate'], 10, 2);
    }

    /**
     * @param $template
     * @param $template_name
     * @return mixed|string
     */
    public function tryLocateWoocommerceTemplate($template, $template_name): mixed
    {
        $t = WRCE_ROOT_PATH . 'templates/' . $template_name;
        return is_file($t) ? $t : $template;
    }

}