<?php

namespace RTMCustomMails\EmailSections\Defaults;

class AdminFailedOrderDefaultTemplate implements DefaultTemplateInterface
{

    /**
     * Returns the email id asociated with this template
     * @return string
     */
    public static function getEmailId(): string
    {
        return 'failed_order';
    }

    /**
     * Returns the default sections for this email
     * @return array EmailSection[]
     */
    public static function getDefaultSections(): array
    {
        return [
            [
                'id' => 'woocommerce_email_header',
                'enable' => true,
                'title' => 'Header',
                'showTitle' => false,
                'text' => '',
                'condition' => [],
                'sortOrder' => 0,
            ],
            [
                'id' => '',
                'enable' => true,
                'title' => 'Main Text',
                'showTitle' => true,
                'text' => esc_html__('Payment for order {{ order_number }} from {{ formatted_billing_full_name }} has failed. The order was as follows:', 'woocommerce'),
                'condition' => [],
                'sortOrder' => 2,
            ],
            [
                'id' => 'woocommerce_email_order_details',
                'enable' => true,
                'title' => 'Order Details',
                'showTitle' => false,
                'text' => '',
                'condition' => [],
                'sortOrder' => 3,
            ],
            [
                'id' => 'woocommerce_email_order_meta',
                'enable' => true,
                'title' => 'Order Meta',
                'showTitle' => false,
                'text' => '',
                'condition' => [],
                'sortOrder' => 3,
            ],
            [
                'id' => 'woocommerce_email_customer_details',
                'enable' => true,
                'title' => 'Customer Details',
                'showTitle' => false,
                'text' => '',
                'condition' => [],
                'sortOrder' => 4,
            ],
            [
                'id' => 'woocommerce_email_additional_content',
                'enable' => true,
                'title' => 'Additional Content',
                'showTitle' => false,
                'text' => '',
                'condition' => [],
                'sortOrder' => 5,
            ],
            [
                'id' => 'woocommerce_email_footer',
                'enable' => true,
                'title' => 'Footer',
                'showTitle' => false,
                'text' => '',
                'condition' => [],
                'sortOrder' => 6,
            ]
        ];
    }
}
