<?php

namespace RTMCustomMails\ConditionProcessor;

use RTMCustomMails\SupportedObjectTypes;
use RTMMailComposer\ConditionProcessor\ConditionFunctionInterface;
use WC_Abstract_Order;

class OrderHasCouponCondition implements ConditionFunctionInterface
{
    public function __construct()
    {
    }

    public function getName(): string
    {
        return 'order_has_coupon';
    }

    public function getParameters(): array
    {
        return [];
    }

    public function evaluate(array $context): bool
    {
        /** @var WC_Abstract_Order|null $order */
        $order = $context['order'] ?? null;

        if (!$order) {
            return false;
        }

        // Check if the order has any coupons applied
        return !empty($order->get_used_coupons());
    }

    public function getObjectType(): string
    {
        return SupportedObjectTypes::ORDER->value;
    }
}
