<?php
/*
 * Copyright (c) 2023. RTM Business
 */

namespace WordpressModels\ORM\EntityTrait;

use DateTime;
use Doctrine\ORM\Events;
use Doctrine\ORM\Mapping\Column;
use Symfony\Component\Serializer\Annotation\Groups;
use WordpressModels\ORM\Attributes\Timestamp;

trait Timestampable
{

    use SoftDeletable;

    #[Column(type: 'datetime')]
    #[Groups(['read_timestamps'])]
    #[Timestamp(Events::prePersist)]
    protected ?DateTime $createdAt = null;

    #[Column(type: 'datetime', nullable: true)]
    #[Groups(['read_timestamps'])]
    #[Timestamp(Events::preUpdate)]
    protected ?DateTime $updatedAt = null;

    /**
     * @return DateTime|null
     */
    public function getCreatedAt(): ?DateTime
    {
        return $this->createdAt;
    }

    /**
     * @return DateTime|null
     */
    public function getUpdatedAt(): ?DateTime
    {
        return $this->updatedAt;
    }

    /**
     * @param DateTime|null $createdAt
     * @return self
     */
    public function setCreatedAt(?DateTime $createdAt): self
    {
        $this->createdAt = $createdAt;
        return $this;
    }

    /**
     * @param DateTime|null $updatedAt
     * @return self
     */
    public function setUpdatedAt(?DateTime $updatedAt): self
    {
        $this->updatedAt = $updatedAt;
        return $this;
    }

}
