#! /bin/bash

FILE=.version

# remove old version file
if [ -f ${FILE} ]; then
  rm ${FILE}
fi

# generate new version file
if [ "${CI_COMMIT_TAG}" ]; then
  echo "${CI_COMMIT_TAG}" > ${FILE}
elif [ "${CI_COMMIT_BRANCH}" ] && [ "${CI_COMMIT_SHORT_SHA}" ]; then
  echo "${CI_COMMIT_BRANCH}-${CI_COMMIT_SHORT_SHA}" > ${FILE}
elif [ "${CI_COMMIT_SHORT_SHA}" ]; then
  echo "${CI_COMMIT_SHORT_SHA}" > ${FILE}
else
  echo "0.0.0" > ${FILE}
fi

# get the version from the file
VERSION=$(cat ${FILE})