<?php

namespace RTMCustomMails\Pages;

use WordpressModels\Traits\SingletonTrait;

class ScheduledEmailsPage extends Page
{

    use SingletonTrait;
    use WrcePageJsContextTrait;

    /**
     * @var array|mixed
     */
    private array $filter = [];
    private string $orderBy = 'date';
    private string $order = 'DESC';
    private int $limit = 20;
    private int $offset = 0;

    public function __construct()
    {
        parent::__construct(
            'scheduled-emails',
            'scheduled_emails',
            __('Scheduled Emails'),
            position: 1000
        );
    }

    public function init(): void
    {
        parent::init();
    }

    /**
     * @param $context
     * @return array
     */
    public function buildContext($context = []): array
    {
        return $context;
    }

    public function doEnqueue(): void
    {
        $this->addJsContext($this->pageId);
    }
}
