<?php

namespace RTMCustomMails\EmailSections\Defaults;

use RTMMailComposer\Model\EmailSection;

class CustomerInvoiceDefaultTemplate implements DefaultTemplateInterface
{

    /**
     * Returns the email id asociated with this template
     * @return string
     */
    public static function getEmailId(): string
    {
        return 'customer_invoice';
    }

    /**
     * Returns the default sections for this email
     * @return array EmailSection[]
     */
    public static function getDefaultSections(): array
    {
        return [
            [
                'id' => 'woocommerce_email_header',
                'enable' => true,
                'title' => 'Header',
                'showTitle' => false,
                'text' => '',
                'condition' => [],
                'sortOrder' => 0,
            ],
            [
                'id' => 'greeting',
                'enable' => true,
                'title' => 'Greeting',
                'showTitle' => true,
                'text' => esc_html__('Hi {{ billing_first_name }},', 'woocommerce'),
                'condition' => [],
                'sortOrder' => 2,
            ],
            [
                'id' => 'main_text',
                'enable' => true,
                'title' => 'Main Text',
                'showTitle' => false,
                'text' => <<<TWIG
{% if (order_needs_payment) %}
    An order has been created for you on {{ site_title }}. Your invoice is below, with a link to make payment when you’re ready: {{ order_payment_link(order, 'Pay for this order') }}
{% else %}
    Here are the details of your order placed on {{ order_date }}:
{% endif %}
TWIG,
                'condition' => [],
                'sortOrder' => 2,
            ],
            [
                'id' => 'woocommerce_email_order_details',
                'enable' => true,
                'title' => 'Order Details',
                'showTitle' => false,
                'text' => '',
                'condition' => [],
                'sortOrder' => 3,
            ],
            [
                'id' => 'woocommerce_email_order_meta',
                'enable' => true,
                'title' => 'Order Meta',
                'showTitle' => false,
                'text' => '',
                'condition' => [],
                'sortOrder' => 3,
            ],
            [
                'id' => 'woocommerce_email_customer_details',
                'enable' => true,
                'title' => 'Customer Details',
                'showTitle' => false,
                'text' => '',
                'condition' => [],
                'sortOrder' => 4,
            ],
            [
                'id' => 'woocommerce_email_additional_content',
                'enable' => true,
                'title' => 'Additional Content',
                'showTitle' => false,
                'text' => '',
                'condition' => [],
                'sortOrder' => 5,
            ],
            [
                'id' => 'woocommerce_email_footer',
                'enable' => true,
                'title' => 'Footer',
                'showTitle' => false,
                'text' => '',
                'condition' => [],
                'sortOrder' => 6,
            ]
        ];
    }
}
