<?php
/*
 * Copyright (c) 2023. RTM Business
 */

namespace RTMCustomMails\EmailOptions;

use WC_Email;

/**
 * @template O
 */
abstract class AbstractEmailEnabledCondition extends AbstractEmailOption
{

    public function __construct(WC_Email $email)
    {
        parent::__construct($email);
        add_filter('woocommerce_email_enabled_' . $email->id, [$this, 'handleEnabledCondition'], 10, 3);
    }

    /**
     * @param bool $enabled
     * @param O $obj
     * @param WC_Email|null $email
     * @return mixed
     */
    abstract public function handleEnabledCondition(bool $enabled, mixed $obj, WC_Email $email = null);

}
