"use strict";
/*
 * ATTENTION: The "eval" devtool has been used (maybe by default in mode: "development").
 * This devtool is neither made for production nor for readable output files.
 * It uses "eval()" calls to create a separate source file in the browser devtools.
 * If you are trying to read the output file, select a different devtool (https://webpack.js.org/configuration/devtool/)
 * or disable the default devtool with "devtool: false".
 * If you are looking for production-ready output files, see mode: "production" (https://webpack.js.org/configuration/mode/).
 */
(self["webpackChunkwoocommerce_rtm_custom_emails"] = self["webpackChunkwoocommerce_rtm_custom_emails"] || []).push([["defaultVendors-1011~1013-22d8ae327198b702bd868aa0e11175dd-retrieveSchema.js"],{

/***/ 11913:
/*!***************************************************************!*\
  !*** ./node_modules/@rjsf/utils/lib/schema/retrieveSchema.js ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"default\": () => (/* binding */ retrieveSchema),\n/* harmony export */   \"getAllPermutationsOfXxxOf\": () => (/* binding */ getAllPermutationsOfXxxOf),\n/* harmony export */   \"processDependencies\": () => (/* binding */ processDependencies),\n/* harmony export */   \"resolveAllReferences\": () => (/* binding */ resolveAllReferences),\n/* harmony export */   \"resolveAnyOrOneOfSchemas\": () => (/* binding */ resolveAnyOrOneOfSchemas),\n/* harmony export */   \"resolveCondition\": () => (/* binding */ resolveCondition),\n/* harmony export */   \"resolveDependencies\": () => (/* binding */ resolveDependencies),\n/* harmony export */   \"resolveReference\": () => (/* binding */ resolveReference),\n/* harmony export */   \"resolveSchema\": () => (/* binding */ resolveSchema),\n/* harmony export */   \"retrieveSchemaInternal\": () => (/* binding */ retrieveSchemaInternal),\n/* harmony export */   \"stubExistingAdditionalProperties\": () => (/* binding */ stubExistingAdditionalProperties),\n/* harmony export */   \"withDependentProperties\": () => (/* binding */ withDependentProperties),\n/* harmony export */   \"withDependentSchema\": () => (/* binding */ withDependentSchema),\n/* harmony export */   \"withExactlyOneSubschema\": () => (/* binding */ withExactlyOneSubschema)\n/* harmony export */ });\n/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! tslib */ 70655);\n/* harmony import */ var lodash_get__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! lodash/get */ 27361);\n/* harmony import */ var lodash_get__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(lodash_get__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var lodash_set__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! lodash/set */ 36968);\n/* harmony import */ var lodash_set__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(lodash_set__WEBPACK_IMPORTED_MODULE_1__);\n/* harmony import */ var lodash_times__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! lodash/times */ 98913);\n/* harmony import */ var lodash_times__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(lodash_times__WEBPACK_IMPORTED_MODULE_2__);\n/* harmony import */ var lodash_transform__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! lodash/transform */ 68718);\n/* harmony import */ var lodash_transform__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(lodash_transform__WEBPACK_IMPORTED_MODULE_3__);\n/* harmony import */ var json_schema_merge_allof__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! json-schema-merge-allof */ 19830);\n/* harmony import */ var json_schema_merge_allof__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(json_schema_merge_allof__WEBPACK_IMPORTED_MODULE_4__);\n/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../constants */ 27322);\n/* harmony import */ var _findSchemaDefinition__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../findSchemaDefinition */ 70160);\n/* harmony import */ var _getDiscriminatorFieldFromSchema__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../getDiscriminatorFieldFromSchema */ 30683);\n/* harmony import */ var _guessType__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../guessType */ 89887);\n/* harmony import */ var _isObject__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../isObject */ 73999);\n/* harmony import */ var _mergeSchemas__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../mergeSchemas */ 91828);\n/* harmony import */ var _getFirstMatchingOption__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./getFirstMatchingOption */ 2944);\n\n\n\n\n\n\n\n\n\n\n\n\n\n/** Retrieves an expanded schema that has had all of its conditions, additional properties, references and dependencies\n * resolved and merged into the `schema` given a `validator`, `rootSchema` and `rawFormData` that is used to do the\n * potentially recursive resolution.\n *\n * @param validator - An implementation of the `ValidatorType` interface that will be forwarded to all the APIs\n * @param schema - The schema for which retrieving a schema is desired\n * @param [rootSchema={}] - The root schema that will be forwarded to all the APIs\n * @param [rawFormData] - The current formData, if any, to assist retrieving a schema\n * @returns - The schema having its conditions, additional properties, references and dependencies resolved\n */\nfunction retrieveSchema(validator, schema, rootSchema = {}, rawFormData) {\n    return retrieveSchemaInternal(validator, schema, rootSchema, rawFormData)[0];\n}\n/** Resolves a conditional block (if/else/then) by removing the condition and merging the appropriate conditional branch\n * with the rest of the schema. If `expandAllBranches` is true, then the `retrieveSchemaInteral()` results for both\n * conditions will be returned.\n *\n * @param validator - An implementation of the `ValidatorType` interface that is used to detect valid schema conditions\n * @param schema - The schema for which resolving a condition is desired\n * @param rootSchema - The root schema that will be forwarded to all the APIs\n * @param expandAllBranches - Flag, if true, will return all possible branches of conditions, any/oneOf and\n *          dependencies as a list of schemas\n * @param [formData] - The current formData to assist retrieving a schema\n * @returns - A list of schemas with the appropriate conditions resolved, possibly with all branches expanded\n */\nfunction resolveCondition(validator, schema, rootSchema, expandAllBranches, formData) {\n    const { if: expression, then, else: otherwise } = schema, resolvedSchemaLessConditional = (0,tslib__WEBPACK_IMPORTED_MODULE_12__.__rest)(schema, [\"if\", \"then\", \"else\"]);\n    const conditionValue = validator.isValid(expression, formData || {}, rootSchema);\n    let resolvedSchemas = [resolvedSchemaLessConditional];\n    let schemas = [];\n    if (expandAllBranches) {\n        if (then && typeof then !== 'boolean') {\n            schemas = schemas.concat(retrieveSchemaInternal(validator, then, rootSchema, formData, expandAllBranches));\n        }\n        if (otherwise && typeof otherwise !== 'boolean') {\n            schemas = schemas.concat(retrieveSchemaInternal(validator, otherwise, rootSchema, formData, expandAllBranches));\n        }\n    }\n    else {\n        const conditionalSchema = conditionValue ? then : otherwise;\n        if (conditionalSchema && typeof conditionalSchema !== 'boolean') {\n            schemas = schemas.concat(retrieveSchemaInternal(validator, conditionalSchema, rootSchema, formData, expandAllBranches));\n        }\n    }\n    if (schemas.length) {\n        resolvedSchemas = schemas.map((s) => (0,_mergeSchemas__WEBPACK_IMPORTED_MODULE_10__[\"default\"])(resolvedSchemaLessConditional, s));\n    }\n    return resolvedSchemas.flatMap((s) => retrieveSchemaInternal(validator, s, rootSchema, formData, expandAllBranches));\n}\n/** Given a list of lists of allOf, anyOf or oneOf values, create a list of lists of all permutations of the values. The\n * `listOfLists` is expected to be all resolved values of the 1st...nth schemas within an `allOf`, `anyOf` or `oneOf`.\n * From those lists, build a matrix for each `xxxOf` where there is more than one schema for a row in the list of lists.\n *\n * For example:\n * - If there are three xxxOf rows (A, B, C) and they have been resolved such that there is only one A, two B and three\n *   C schemas then:\n *   - The permutation for the first row is `[[A]]`\n *   - The permutations for the second row are `[[A,B1], [A,B2]]`\n *   - The permutations for the third row are `[[A,B1,C1], [A,B1,C2], [A,B1,C3], [A,B2,C1], [A,B2,C2], [A,B2,C3]]`\n *\n * @param listOfLists - The list of lists of elements that represent the allOf, anyOf or oneOf resolved values in order\n * @returns - The list of all permutations of schemas for a set of `xxxOf`s\n */\nfunction getAllPermutationsOfXxxOf(listOfLists) {\n    const allPermutations = listOfLists.reduce((permutations, list) => {\n        // When there are more than one set of schemas for a row, duplicate the set of permutations and add in the values\n        if (list.length > 1) {\n            return list.flatMap((element) => lodash_times__WEBPACK_IMPORTED_MODULE_2___default()(permutations.length, (i) => [...permutations[i]].concat(element)));\n        }\n        // Otherwise just push in the single value into the current set of permutations\n        permutations.forEach((permutation) => permutation.push(list[0]));\n        return permutations;\n    }, [[]] // Start with an empty list\n    );\n    return allPermutations;\n}\n/** Resolves references and dependencies within a schema and its 'allOf' children. Passes the `expandAllBranches` flag\n * down to the `retrieveSchemaInternal()`, `resolveReference()` and `resolveDependencies()` helper calls. If\n * `expandAllBranches` is true, then all possible dependencies and/or allOf branches are returned.\n *\n * @param validator - An implementation of the `ValidatorType` interface that will be forwarded to all the APIs\n * @param schema - The schema for which resolving a schema is desired\n * @param rootSchema - The root schema that will be forwarded to all the APIs\n * @param expandAllBranches - Flag, if true, will return all possible branches of conditions, any/oneOf and dependencies\n *          as a list of schemas\n * @param [formData] - The current formData, if any, to assist retrieving a schema\n * @returns - The list of schemas having its references, dependencies and allOf schemas resolved\n */\nfunction resolveSchema(validator, schema, rootSchema, expandAllBranches, formData) {\n    if (_constants__WEBPACK_IMPORTED_MODULE_5__.REF_KEY in schema) {\n        return resolveReference(validator, schema, rootSchema, expandAllBranches, formData);\n    }\n    if (_constants__WEBPACK_IMPORTED_MODULE_5__.DEPENDENCIES_KEY in schema) {\n        const resolvedSchemas = resolveDependencies(validator, schema, rootSchema, expandAllBranches, formData);\n        return resolvedSchemas.flatMap((s) => {\n            return retrieveSchemaInternal(validator, s, rootSchema, formData, expandAllBranches);\n        });\n    }\n    if (_constants__WEBPACK_IMPORTED_MODULE_5__.ALL_OF_KEY in schema && Array.isArray(schema.allOf)) {\n        const allOfSchemaElements = schema.allOf.map((allOfSubschema) => retrieveSchemaInternal(validator, allOfSubschema, rootSchema, formData, expandAllBranches));\n        const allPermutations = getAllPermutationsOfXxxOf(allOfSchemaElements);\n        return allPermutations.map((permutation) => (Object.assign(Object.assign({}, schema), { allOf: permutation })));\n    }\n    // No $ref or dependencies or allOf attribute was found, returning the original schema.\n    return [schema];\n}\n/** Resolves references within a schema and then returns the `retrieveSchemaInternal()` of the resolved schema. Passes\n * the `expandAllBranches` flag down to the `retrieveSchemaInternal()` helper call.\n *\n * @param validator - An implementation of the `ValidatorType` interface that will be forwarded to all the APIs\n * @param schema - The schema for which resolving a reference is desired\n * @param rootSchema - The root schema that will be forwarded to all the APIs\n * @param expandAllBranches - Flag, if true, will return all possible branches of conditions, any/oneOf and dependencies\n *          as a list of schemas\n * @param [formData] - The current formData, if any, to assist retrieving a schema\n * @returns - The list schemas retrieved after having all references resolved\n */\nfunction resolveReference(validator, schema, rootSchema, expandAllBranches, formData) {\n    // Drop the $ref property of the source schema.\n    const { $ref } = schema, localSchema = (0,tslib__WEBPACK_IMPORTED_MODULE_12__.__rest)(schema, [\"$ref\"]);\n    // Retrieve the referenced schema definition.\n    const refSchema = (0,_findSchemaDefinition__WEBPACK_IMPORTED_MODULE_6__[\"default\"])($ref, rootSchema);\n    // Update referenced schema definition with local schema properties.\n    return retrieveSchemaInternal(validator, Object.assign(Object.assign({}, refSchema), localSchema), rootSchema, formData, expandAllBranches);\n}\n/** Resolves all references within a schema's properties and array items.\n *\n * @param schema - The schema for which resolving all references is desired\n * @param rootSchema - The root schema that will be forwarded to all the APIs\n * @returns - given schema will all references resolved\n */\nfunction resolveAllReferences(schema, rootSchema) {\n    let resolvedSchema = schema;\n    // resolve top level ref\n    if (_constants__WEBPACK_IMPORTED_MODULE_5__.REF_KEY in resolvedSchema) {\n        const { $ref } = resolvedSchema, localSchema = (0,tslib__WEBPACK_IMPORTED_MODULE_12__.__rest)(resolvedSchema, [\"$ref\"]);\n        // Retrieve the referenced schema definition.\n        const refSchema = (0,_findSchemaDefinition__WEBPACK_IMPORTED_MODULE_6__[\"default\"])($ref, rootSchema);\n        resolvedSchema = Object.assign(Object.assign({}, refSchema), localSchema);\n    }\n    if (_constants__WEBPACK_IMPORTED_MODULE_5__.PROPERTIES_KEY in resolvedSchema) {\n        const updatedProps = lodash_transform__WEBPACK_IMPORTED_MODULE_3___default()(resolvedSchema[_constants__WEBPACK_IMPORTED_MODULE_5__.PROPERTIES_KEY], (result, value, key) => {\n            result[key] = resolveAllReferences(value, rootSchema);\n        }, {});\n        resolvedSchema = Object.assign(Object.assign({}, resolvedSchema), { [_constants__WEBPACK_IMPORTED_MODULE_5__.PROPERTIES_KEY]: updatedProps });\n    }\n    if (_constants__WEBPACK_IMPORTED_MODULE_5__.ITEMS_KEY in resolvedSchema &&\n        !Array.isArray(resolvedSchema.items) &&\n        typeof resolvedSchema.items !== 'boolean') {\n        resolvedSchema = Object.assign(Object.assign({}, resolvedSchema), { items: resolveAllReferences(resolvedSchema.items, rootSchema) });\n    }\n    return resolvedSchema;\n}\n/** Creates new 'properties' items for each key in the `formData`\n *\n * @param validator - An implementation of the `ValidatorType` interface that will be used when necessary\n * @param theSchema - The schema for which the existing additional properties is desired\n * @param [rootSchema] - The root schema, used to primarily to look up `$ref`s * @param validator\n * @param [aFormData] - The current formData, if any, to assist retrieving a schema\n * @returns - The updated schema with additional properties stubbed\n */\nfunction stubExistingAdditionalProperties(validator, theSchema, rootSchema, aFormData) {\n    // Clone the schema so that we don't ruin the consumer's original\n    const schema = Object.assign(Object.assign({}, theSchema), { properties: Object.assign({}, theSchema.properties) });\n    // make sure formData is an object\n    const formData = aFormData && (0,_isObject__WEBPACK_IMPORTED_MODULE_9__[\"default\"])(aFormData) ? aFormData : {};\n    Object.keys(formData).forEach((key) => {\n        if (key in schema.properties) {\n            // No need to stub, our schema already has the property\n            return;\n        }\n        let additionalProperties = {};\n        if (typeof schema.additionalProperties !== 'boolean') {\n            if (_constants__WEBPACK_IMPORTED_MODULE_5__.REF_KEY in schema.additionalProperties) {\n                additionalProperties = retrieveSchema(validator, { $ref: lodash_get__WEBPACK_IMPORTED_MODULE_0___default()(schema.additionalProperties, [_constants__WEBPACK_IMPORTED_MODULE_5__.REF_KEY]) }, rootSchema, formData);\n            }\n            else if ('type' in schema.additionalProperties) {\n                additionalProperties = Object.assign({}, schema.additionalProperties);\n            }\n            else if (_constants__WEBPACK_IMPORTED_MODULE_5__.ANY_OF_KEY in schema.additionalProperties || _constants__WEBPACK_IMPORTED_MODULE_5__.ONE_OF_KEY in schema.additionalProperties) {\n                additionalProperties = Object.assign({ type: 'object' }, schema.additionalProperties);\n            }\n            else {\n                additionalProperties = { type: (0,_guessType__WEBPACK_IMPORTED_MODULE_8__[\"default\"])(lodash_get__WEBPACK_IMPORTED_MODULE_0___default()(formData, [key])) };\n            }\n        }\n        else {\n            additionalProperties = { type: (0,_guessType__WEBPACK_IMPORTED_MODULE_8__[\"default\"])(lodash_get__WEBPACK_IMPORTED_MODULE_0___default()(formData, [key])) };\n        }\n        // The type of our new key should match the additionalProperties value;\n        schema.properties[key] = additionalProperties;\n        // Set our additional property flag so we know it was dynamically added\n        lodash_set__WEBPACK_IMPORTED_MODULE_1___default()(schema.properties, [key, _constants__WEBPACK_IMPORTED_MODULE_5__.ADDITIONAL_PROPERTY_FLAG], true);\n    });\n    return schema;\n}\n/** Internal handler that retrieves an expanded schema that has had all of its conditions, additional properties,\n * references and dependencies resolved and merged into the `schema` given a `validator`, `rootSchema` and `rawFormData`\n * that is used to do the potentially recursive resolution. If `expandAllBranches` is true, then all possible branches\n * of the schema and its references, conditions and dependencies are returned.\n *\n * @param validator - An implementation of the `ValidatorType` interface that will be forwarded to all the APIs\n * @param schema - The schema for which retrieving a schema is desired\n * @param rootSchema - The root schema that will be forwarded to all the APIs\n * @param [rawFormData] - The current formData, if any, to assist retrieving a schema\n * @param [expandAllBranches=false] - Flag, if true, will return all possible branches of conditions, any/oneOf and\n *          dependencies as a list of schemas\n * @returns - The schema(s) resulting from having its conditions, additional properties, references and dependencies\n *          resolved. Multiple schemas may be returned if `expandAllBranches` is true.\n */\nfunction retrieveSchemaInternal(validator, schema, rootSchema, rawFormData, expandAllBranches = false) {\n    if (!(0,_isObject__WEBPACK_IMPORTED_MODULE_9__[\"default\"])(schema)) {\n        return [{}];\n    }\n    const resolvedSchemas = resolveSchema(validator, schema, rootSchema, expandAllBranches, rawFormData);\n    return resolvedSchemas.flatMap((s) => {\n        let resolvedSchema = s;\n        if (_constants__WEBPACK_IMPORTED_MODULE_5__.IF_KEY in resolvedSchema) {\n            return resolveCondition(validator, resolvedSchema, rootSchema, expandAllBranches, rawFormData);\n        }\n        if (_constants__WEBPACK_IMPORTED_MODULE_5__.ALL_OF_KEY in resolvedSchema) {\n            // resolve allOf schemas\n            if (expandAllBranches) {\n                return [...resolvedSchema.allOf];\n            }\n            try {\n                resolvedSchema = json_schema_merge_allof__WEBPACK_IMPORTED_MODULE_4___default()(resolvedSchema, {\n                    deep: false,\n                });\n            }\n            catch (e) {\n                console.warn('could not merge subschemas in allOf:\\n', e);\n                const { allOf } = resolvedSchema, resolvedSchemaWithoutAllOf = (0,tslib__WEBPACK_IMPORTED_MODULE_12__.__rest)(resolvedSchema, [\"allOf\"]);\n                return resolvedSchemaWithoutAllOf;\n            }\n        }\n        const hasAdditionalProperties = _constants__WEBPACK_IMPORTED_MODULE_5__.ADDITIONAL_PROPERTIES_KEY in resolvedSchema && resolvedSchema.additionalProperties !== false;\n        if (hasAdditionalProperties) {\n            return stubExistingAdditionalProperties(validator, resolvedSchema, rootSchema, rawFormData);\n        }\n        return resolvedSchema;\n    });\n}\n/** Resolves an `anyOf` or `oneOf` within a schema (if present) to the list of schemas returned from\n * `retrieveSchemaInternal()` for the best matching option. If `expandAllBranches` is true, then a list of schemas for ALL\n * options are retrieved and returned.\n *\n * @param validator - An implementation of the `ValidatorType` interface that will be forwarded to all the APIs\n * @param schema - The schema for which retrieving a schema is desired\n * @param rootSchema - The root schema that will be forwarded to all the APIs\n * @param expandAllBranches - Flag, if true, will return all possible branches of conditions, any/oneOf and dependencies\n *          as a list of schemas\n * @param [rawFormData] - The current formData, if any, to assist retrieving a schema, defaults to an empty object\n * @returns - Either an array containing the best matching option or all options if `expandAllBranches` is true\n */\nfunction resolveAnyOrOneOfSchemas(validator, schema, rootSchema, expandAllBranches, rawFormData) {\n    let anyOrOneOf;\n    const { oneOf, anyOf } = schema, remaining = (0,tslib__WEBPACK_IMPORTED_MODULE_12__.__rest)(schema, [\"oneOf\", \"anyOf\"]);\n    if (Array.isArray(oneOf)) {\n        anyOrOneOf = oneOf;\n    }\n    else if (Array.isArray(anyOf)) {\n        anyOrOneOf = anyOf;\n    }\n    if (anyOrOneOf) {\n        // Ensure that during expand all branches we pass an object rather than undefined so that all options are interrogated\n        const formData = rawFormData === undefined && expandAllBranches ? {} : rawFormData;\n        const discriminator = (0,_getDiscriminatorFieldFromSchema__WEBPACK_IMPORTED_MODULE_7__[\"default\"])(schema);\n        anyOrOneOf = anyOrOneOf.map((s) => {\n            return resolveAllReferences(s, rootSchema);\n        });\n        // Call this to trigger the set of isValid() calls that the schema parser will need\n        const option = (0,_getFirstMatchingOption__WEBPACK_IMPORTED_MODULE_11__[\"default\"])(validator, formData, anyOrOneOf, rootSchema, discriminator);\n        if (expandAllBranches) {\n            return anyOrOneOf.map((item) => (0,_mergeSchemas__WEBPACK_IMPORTED_MODULE_10__[\"default\"])(remaining, item));\n        }\n        schema = (0,_mergeSchemas__WEBPACK_IMPORTED_MODULE_10__[\"default\"])(remaining, anyOrOneOf[option]);\n    }\n    return [schema];\n}\n/** Resolves dependencies within a schema and its 'anyOf/oneOf' children. Passes the `expandAllBranches` flag down to\n * the `resolveAnyOrOneOfSchema()` and `processDependencies()` helper calls.\n *\n * @param validator - An implementation of the `ValidatorType` interface that will be forwarded to all the APIs\n * @param schema - The schema for which resolving a dependency is desired\n * @param rootSchema - The root schema that will be forwarded to all the APIs\n * @param expandAllBranches - Flag, if true, will return all possible branches of conditions, any/oneOf and dependencies\n *          as a list of schemas\n * @param [formData] - The current formData, if any, to assist retrieving a schema\n * @returns - The list of schemas with their dependencies resolved\n */\nfunction resolveDependencies(validator, schema, rootSchema, expandAllBranches, formData) {\n    // Drop the dependencies from the source schema.\n    const { dependencies } = schema, remainingSchema = (0,tslib__WEBPACK_IMPORTED_MODULE_12__.__rest)(schema, [\"dependencies\"]);\n    const resolvedSchemas = resolveAnyOrOneOfSchemas(validator, remainingSchema, rootSchema, expandAllBranches, formData);\n    return resolvedSchemas.flatMap((resolvedSchema) => processDependencies(validator, dependencies, resolvedSchema, rootSchema, expandAllBranches, formData));\n}\n/** Processes all the `dependencies` recursively into the list of `resolvedSchema`s as needed. Passes the\n * `expandAllBranches` flag down to the `withDependentSchema()` and the recursive `processDependencies()` helper calls.\n *\n * @param validator - An implementation of the `ValidatorType` interface that will be forwarded to all the APIs\n * @param dependencies - The set of dependencies that needs to be processed\n * @param resolvedSchema - The schema for which processing dependencies is desired\n * @param rootSchema - The root schema that will be forwarded to all the APIs\n * @param expandAllBranches - Flag, if true, will return all possible branches of conditions, any/oneOf and dependencies\n *          as a list of schemas\n * @param [formData] - The current formData, if any, to assist retrieving a schema\n * @returns - The schema with the `dependencies` resolved into it\n */\nfunction processDependencies(validator, dependencies, resolvedSchema, rootSchema, expandAllBranches, formData) {\n    let schemas = [resolvedSchema];\n    // Process dependencies updating the local schema properties as appropriate.\n    for (const dependencyKey in dependencies) {\n        // Skip this dependency if its trigger property is not present.\n        if (!expandAllBranches && lodash_get__WEBPACK_IMPORTED_MODULE_0___default()(formData, [dependencyKey]) === undefined) {\n            continue;\n        }\n        // Skip this dependency if it is not included in the schema (such as when dependencyKey is itself a hidden dependency.)\n        if (resolvedSchema.properties && !(dependencyKey in resolvedSchema.properties)) {\n            continue;\n        }\n        const [remainingDependencies, dependencyValue] = (0,_findSchemaDefinition__WEBPACK_IMPORTED_MODULE_6__.splitKeyElementFromObject)(dependencyKey, dependencies);\n        if (Array.isArray(dependencyValue)) {\n            schemas[0] = withDependentProperties(resolvedSchema, dependencyValue);\n        }\n        else if ((0,_isObject__WEBPACK_IMPORTED_MODULE_9__[\"default\"])(dependencyValue)) {\n            schemas = withDependentSchema(validator, resolvedSchema, rootSchema, dependencyKey, dependencyValue, expandAllBranches, formData);\n        }\n        return schemas.flatMap((schema) => processDependencies(validator, remainingDependencies, schema, rootSchema, expandAllBranches, formData));\n    }\n    return schemas;\n}\n/** Updates a schema with additionally required properties added\n *\n * @param schema - The schema for which resolving a dependent properties is desired\n * @param [additionallyRequired] - An optional array of additionally required names\n * @returns - The schema with the additional required values merged in\n */\nfunction withDependentProperties(schema, additionallyRequired) {\n    if (!additionallyRequired) {\n        return schema;\n    }\n    const required = Array.isArray(schema.required)\n        ? Array.from(new Set([...schema.required, ...additionallyRequired]))\n        : additionallyRequired;\n    return Object.assign(Object.assign({}, schema), { required: required });\n}\n/** Merges a dependent schema into the `schema` dealing with oneOfs and references. Passes the `expandAllBranches` flag\n * down to the `retrieveSchemaInternal()`, `resolveReference()` and `withExactlyOneSubschema()` helper calls.\n *\n * @param validator - An implementation of the `ValidatorType` interface that will be forwarded to all the APIs\n * @param schema - The schema for which resolving a dependent schema is desired\n * @param rootSchema - The root schema that will be forwarded to all the APIs\n * @param dependencyKey - The key name of the dependency\n * @param dependencyValue - The potentially dependent schema\n * @param expandAllBranches - Flag, if true, will return all possible branches of conditions, any/oneOf and dependencies\n *          as a list of schemas\n * @param [formData]- The current formData to assist retrieving a schema\n * @returns - The list of schemas with the dependent schema resolved into them\n */\nfunction withDependentSchema(validator, schema, rootSchema, dependencyKey, dependencyValue, expandAllBranches, formData) {\n    const dependentSchemas = retrieveSchemaInternal(validator, dependencyValue, rootSchema, formData, expandAllBranches);\n    return dependentSchemas.flatMap((dependent) => {\n        const { oneOf } = dependent, dependentSchema = (0,tslib__WEBPACK_IMPORTED_MODULE_12__.__rest)(dependent, [\"oneOf\"]);\n        schema = (0,_mergeSchemas__WEBPACK_IMPORTED_MODULE_10__[\"default\"])(schema, dependentSchema);\n        // Since it does not contain oneOf, we return the original schema.\n        if (oneOf === undefined) {\n            return schema;\n        }\n        // Resolve $refs inside oneOf.\n        const resolvedOneOfs = oneOf.map((subschema) => {\n            if (typeof subschema === 'boolean' || !(_constants__WEBPACK_IMPORTED_MODULE_5__.REF_KEY in subschema)) {\n                return [subschema];\n            }\n            return resolveReference(validator, subschema, rootSchema, expandAllBranches, formData);\n        });\n        const allPermutations = getAllPermutationsOfXxxOf(resolvedOneOfs);\n        return allPermutations.flatMap((resolvedOneOf) => withExactlyOneSubschema(validator, schema, rootSchema, dependencyKey, resolvedOneOf, expandAllBranches, formData));\n    });\n}\n/** Returns a list of `schema`s with the best choice from the `oneOf` options merged into it. If `expandAllBranches` is\n * true, then a list of schemas for ALL options are retrieved and returned. Passes the `expandAllBranches` flag down to\n * the `retrieveSchemaInternal()` helper call.\n *\n * @param validator - An implementation of the `ValidatorType` interface that will be used to validate oneOf options\n * @param schema - The schema for which resolving a oneOf subschema is desired\n * @param rootSchema - The root schema that will be forwarded to all the APIs\n * @param dependencyKey - The key name of the oneOf dependency\n * @param oneOf - The list of schemas representing the oneOf options\n * @param expandAllBranches - Flag, if true, will return all possible branches of conditions, any/oneOf and dependencies\n *          as a list of schemas\n * @param [formData] - The current formData to assist retrieving a schema\n * @returns - Either an array containing the best matching option or all options if `expandAllBranches` is true\n */\nfunction withExactlyOneSubschema(validator, schema, rootSchema, dependencyKey, oneOf, expandAllBranches, formData) {\n    const validSubschemas = oneOf.filter((subschema) => {\n        if (typeof subschema === 'boolean' || !subschema || !subschema.properties) {\n            return false;\n        }\n        const { [dependencyKey]: conditionPropertySchema } = subschema.properties;\n        if (conditionPropertySchema) {\n            const conditionSchema = {\n                type: 'object',\n                properties: {\n                    [dependencyKey]: conditionPropertySchema,\n                },\n            };\n            return validator.isValid(conditionSchema, formData, rootSchema) || expandAllBranches;\n        }\n        return false;\n    });\n    if (!expandAllBranches && validSubschemas.length !== 1) {\n        console.warn(\"ignoring oneOf in dependencies because there isn't exactly one subschema that is valid\");\n        return [schema];\n    }\n    return validSubschemas.flatMap((s) => {\n        const subschema = s;\n        const [dependentSubschema] = (0,_findSchemaDefinition__WEBPACK_IMPORTED_MODULE_6__.splitKeyElementFromObject)(dependencyKey, subschema.properties);\n        const dependentSchema = Object.assign(Object.assign({}, subschema), { properties: dependentSubschema });\n        const schemas = retrieveSchemaInternal(validator, dependentSchema, rootSchema, formData, expandAllBranches);\n        return schemas.map((s) => (0,_mergeSchemas__WEBPACK_IMPORTED_MODULE_10__[\"default\"])(schema, s));\n    });\n}\n//# sourceMappingURL=retrieveSchema.js.map\n\n//# sourceURL=webpack://woocommerce-rtm-custom-emails/./node_modules/@rjsf/utils/lib/schema/retrieveSchema.js?");

/***/ })

}]);