<?php

namespace RTMMailComposer\Renderer;

use RTMMailComposer\Model\CustomMail;
use RTMMailComposer\Model\EmailSection;

interface EmailRendererInterface
{
    /**
     * Renders a given email
     * @param CustomMail $mail Mail to be rendered
     * @param object $mailObject The mailobject for context building
     *
     * @return string The rendered output for this mail
     */
    public function render(CustomMail $mail, object $mailObject): string;

    /**
     * Handles the rendering of an individual section
     * @param EmailSection $section
     * @param array $context
     *
     * @return string Returns a rendered section
     */
    public function renderSection(EmailSection $section, array $context): string;
}
