<?php

namespace RTMCustomMails\Pages;

use RTMCustomMails\Core;
use WordpressModels\Page\AbstractPageStack;
use WordpressModels\Traits\SingletonTrait;

/**
 *
 */
class EmailOverviewPage extends AbstractPageStack
{

    use SingletonTrait;
    use WrcePageJsContextTrait;


    public function __construct()
    {
        parent::__construct(
            'email-overview',
            'rtm_custom_emails',
            __('Emails', 'wrce'),
            'toplevel',
            'administrator',
            58,
            'dashicons-email-alt',
            ['tailwind-admin'],
            Core::instance()->assets()
        );

        $this->addRoute(
            ScheduledEmailsPage::instance()
        );
    }

    public function init(): void
    {
        parent::init();

        // hide admin notices
        add_action('in_admin_header', [$this, 'hideAdminNotices']);
    }

    public function hideAdminNotices()
    {
        remove_all_actions('admin_notices');
    }

    public function doEnqueue()
    {
        wp_localize_script($this->pageId, 'wpRest', [
            'url' => get_rest_url(),
            'nonce' => wp_create_nonce('wp_rest')
        ]);

        $this->addJsContext($this->pageId);
    }

    /**
     * @inheritDoc
     */
    public function buildContext(array $context = []): array
    {
        return $context;
    }
}
