"use strict";
(self["webpackChunkwoocommerce_rtm_custom_emails"] = self["webpackChunkwoocommerce_rtm_custom_emails"] || []).push([[863],{

/***/ 86863:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

// ESM COMPAT FLAG
__webpack_require__.r(__webpack_exports__);

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  "default": () => (/* binding */ EmailAttachmentsRoute)
});

// EXTERNAL MODULE: external "React"
var external_React_ = __webpack_require__(99196);
var external_React_default = /*#__PURE__*/__webpack_require__.n(external_React_);
// EXTERNAL MODULE: ./node_modules/react-router/dist/index.js
var dist = __webpack_require__(89250);
// EXTERNAL MODULE: ./assets/src/js/react/lib/datafetching/email.ts
var datafetching_email = __webpack_require__(21954);
// EXTERNAL MODULE: ./node_modules/@material-tailwind/react/index.js
var react = __webpack_require__(59335);
;// CONCATENATED MODULE: ./assets/src/js/react/components/EmailAttachmentsList/styles.module.scss
// extracted by mini-css-extract-plugin
/* harmony default export */ const styles_module = ({"listItem":"Wzlx00xvhhkKfVC_RcPi"});
// EXTERNAL MODULE: ./assets/src/js/react/lib/actions/email.ts
var actions_email = __webpack_require__(72926);
;// CONCATENATED MODULE: ./assets/src/js/react/components/EmailAttachmentsList/index.tsx





const { toast } = window;
/* harmony default export */ function EmailAttachmentsList({ email, onEmailUpdated }) {
    const [updating, setUpdating] = (0,external_React_.useState)(null);
    const { data: documents } = (0,datafetching_email/* useSupportedDocuments */.U2)(email);
    const toggle = (0,external_React_.useCallback)((document) => {
        const isAttached = email.attachments.includes(document.slug);
        if (isAttached) {
            email.attachments = email.attachments.filter(slug => slug !== document.slug);
        }
        else {
            email.attachments.push(document.slug);
        }
        setUpdating(document.slug);
        (0,actions_email/* toggleDocument */.W6)(email, document.slug)
            .catch(() => toast.error('Failed to ' + (isAttached ? 'remove' : 'attach') + ' document'))
            .then(() => {
            toast.success('Document ' + (isAttached ? 'removed' : 'attached') + ' successfully');
            onEmailUpdated(email);
        })
            .finally(() => setUpdating(null));
    }, [email, onEmailUpdated]);
    const memoizedEmailAttachments = (0,external_React_.useMemo)(() => email.attachments, [email.attachments]);
    return external_React_default().createElement(react.Card, { color: 'white' },
        external_React_default().createElement("ul", { className: 'px-2' }, documents?.map(document => {
            const isAttached = memoizedEmailAttachments.includes(document.slug);
            return external_React_default().createElement("li", { key: email.id + '-' + document.slug, className: styles_module.listItem },
                external_React_default().createElement("div", { className: 'flex items-center gap-2' },
                    external_React_default().createElement("img", { src: document.icon, alt: document.name, className: 'w-5 h-5' }),
                    document.name),
                external_React_default().createElement(react.Button, { size: 'sm', color: isAttached ? 'red' : 'blue-gray', type: 'button', onClick: () => toggle(document), disabled: Boolean(updating), className: 'inline-flex' },
                    updating === document.slug && external_React_default().createElement(react.Spinner, { className: 'mr-1 h-4 w-4' }),
                    isAttached ? 'Remove' : 'Attach'));
        })));
}

;// CONCATENATED MODULE: ./assets/src/js/react/routes/EmailAttachmentsRoute.tsx



/* harmony default export */ function EmailAttachmentsRoute() {
    const ctx = (0,dist/* useOutletContext */.bx)();
    const onUpdated = () => { };
    return external_React_default().createElement(EmailAttachmentsList, { key: ctx.email.id, email: ctx.email, onEmailUpdated: onUpdated });
}


/***/ })

}]);